# 🔐 CVE-2025-41115: Critical Grafana SCIM Privilege Escalation

![218fa54275e0e31c37b4e5091d9112ba_M](https://github.com/user-attachments/assets/3f2ff109-3016-4592-8d01-b5d503a7baaf)

**Critical SCIM Privilege-Escalation Vulnerability in Grafana Enterprise**

---

## 🌟 Summary

CVE-2025-41115 is a **Critical (CVSS 10.0)** vulnerability in **Grafana Enterprise** affecting its **SCIM user-provisioning** feature.

When **SCIM provisioning is enabled** and `user_sync_enabled = true`, a malicious SCIM client can send a **numeric `externalId`**, which Grafana mistakenly maps to an internal user ID — allowing an attacker to **impersonate** or **overwrite** existing accounts, including **admins**.
⚠️ **Grafana OSS is NOT affected.**

---

## 🚨 Impact

* 🔓 **Account takeover** (including admin accounts)
* 🚀 **Privilege escalation** with full admin rights
* 🗄️ **Access to dashboards / data / org configurations**
* 🌐 **Network-exploitable** with low requirements
* 🛑 **High-risk** for multi-tenant or enterprise SSO setups

**Conditions required for exploitation:**

1. `enableSCIM = true`
2. `[auth.scim] user_sync_enabled = true`

---

## 🧩 Affected Versions

| Version                | Status       |
| ---------------------- | ------------ |
| 12.0.0 → 12.2.1        | ❌ Vulnerable |
| 12.3.0                 | ✅ Patched    |
| 12.2.1 (patched build) | ✅ Patched    |
| 12.1.3                 | ✅ Patched    |
| 12.0.6                 | ✅ Patched    |

💡 **Managed Grafana services (AWS/Azure/Grafana Cloud)** were patched by the vendors.


---

### How to use it in 3 seconds:

# 1. Download
```
sudo git clone https://github.com/B1ack4sh/Blackash-CVE-2025-41115.git
```

*or just copy-paste the script above into a file*

# 2. Make executable (optional)
````
chmod +x CVE-2025-41115.py
````

# 3. Fire
```
python3 CVE-2025-41115.py http://10.10.13.37:3000
# or
python3 CVE-2025-41115.py https://grafana.company.com
```

*When the exploit actually works (i.e., the target is vulnerable and the token is valid), you will see output exactly like this:
text*

```python
[*] CVE-2025-41115 → Targeting http://10.10.13.37:3000
[*] Trying default/leaked tokens + your token...
[+] PWNED with token → glsa_XxXxXxXxXxXxXxXxXxXx...
[+] Login as: rooted1732212345@pwn.lab (any password) → you are now Admin!
[+] Full response: {
  "schemas": [
    "urn:ietf:params:scim:schemas:core:2.0:User"
  ],
  "id": "1",                     ←←← THIS IS THE KEY LINE (UID 1 overwritten)
  "externalId": "1",
  "meta": { ... },
  "userName": "rooted1732212345@pwn.lab",
  "name": {
    "formatted": "Pwned User"
  },
  "emails": [
    {
      "value": "rooted1732212345@pwn.lab",
      "primary": true
    }
  ],
  "active": true
}
```

---

## 🔧 Mitigation Steps

### 🥇 1. **Upgrade Immediately**

Update to **12.3.0** or one of the patched maintenance releases.

### 🛠️ 2. **Check your SCIM configuration**

If you’re not using SCIM provisioning, ensure you have:

```
enableSCIM = false
```

or

```
[auth.scim]
user_sync_enabled = false
```

### 📜 3. **Audit logs**

Look for:

* Unexpected new users
* Numeric `externalId` usage
* Privilege changes

### 🔐 4. Trust boundaries

Ensure only **trusted identity providers** are allowed to talk to your SCIM endpoint.

### 👀 5. Monitor for exploitation

Watch for suspicious logins, user creation events, or admin takeovers.

---

## 📅 Timeline

* 📌 **2025-11-04** — Issue discovered internally
* 📌 **2025-11-04** — Incident declared
* 📌 **2025-11-05** — Cloud vendors privately notified & patched
* 📌 **2025-11-19** — Public disclosure and official fix released

---

## 📝 Extra Notes

* 🎯 The flaw is specifically due to Grafana mapping **numeric externalId → internal uid**.
* 🟢 Exploitation requires SCIM **with user syncing**, so many deployments are safe by default — but you must confirm.
* ⚡ No confirmed in-the-wild exploitation at disclosure time, but the CVSS 10 score means it’s extremely dangerous.

---

### *disclaimer!!!*

This PoC is for authorized security testing and educational use only in systems you own or have explicit written permission to test. Unauthorized use is illegal and may result in criminal prosecution. The author and distributor assume no liability for misuse. Patch immediately (≥12.0.6 / 12.3.0+).
