# Open5GS NRF Denial of Service (CVE-2025-41067 & CVE-2025-41068)

This repository contains Proof-of-Concept (PoC) exploit scripts for two high-severity vulnerabilities discovered in NewPlane's Open5GS. These vulnerabilities can be triggered by an attacker to cause a Denial of Service (DoS) in the NRF (Network Repository Function) component.

## Vulnerability Details

*   **CVEs:** `CVE-2025-41067`, `CVE-2025-41068`
*   **Affected Software:** Open5GS
*   **Affected Component:** Network Repository Function (NRF)
*   **Affected Versions:** Prior to `2.7.6`
*   **Impact:** Denial of Service (DoS)
*   **GitHub Issues:**
    * [CVE-2025-41067](https://github.com/open5gs/open5gs/issues/3845)
    * [CVE-2025-41068](https://github.com/open5gs/open5gs/issues/3846)

## Official Advisory

The coordinated disclosure and official advisory for these vulnerabilities can be found on INCIBE's website:
*   [**INCIBE-CERT Advisory: Multiple vulnerabilities in NewPlane's Open5GS**](https://www.incibe.es/en/incibe-cert/notices/aviso/multiple-vulnerabilities-newplanes-open5gs)

## Description

The vulnerabilities are reachable assertions within the Open5GS NRF. An attacker with network connectivity to the NRF's HTTP/2 interface can send specific sequences of API requests that cause the `open5gs-nrfd` process to crash. This renders the 5G network's discovery service inoperable.

This repository includes two distinct scripts to trigger the crash through different methods.

### Scripts Included

1.  **`CVE-2025-41067.py`**
    This script triggers the vulnerability by performing the following actions:
    *   It queries the `/nnrf-nfm/v1/nf-instances` endpoint to get a list of all network functions.
    *   It iterates through the results, identifying any instances where `nfType` is `NRF`.
    *   It then sends a `DELETE` request for each identified NRF instance. This action on a self-referential instance causes the NRF process to crash.

2.  **`CVE-2025-41068.py`**
    This script triggers a similar vulnerability through a different vector:
    *   It first sends a `PUT` request to register a new NF instance with a **non-existent `nfType` ('EMF')**.
    *   Subsequently, when the script requests a list of all NF instances, the NRF attempts to process this invalid entry, which crashes the service.

## Prerequisites

*   Python 3.6+
*   The `httpx` library with HTTP/2 support.

You can install the necessary dependency with pip:
```bash
pip install -r requirements.txt
```

## Usage

Both scripts are run from the command line, with the IP address of the target Open5GS NRF as the only argument.

**To run the deletion-based exploit:**
```bash
python CVE-2025-41067.py <NRF_TARGET_IP>
```

**To run the registration-based exploit:**
```bash
python CVE-2025-41068.py <NRF_TARGET_IP>
```

**Example:**
```bash
python CVE-2025-41067.py 192.168.50.10
```

## Disclaimer

These scripts are intended for educational purposes, authorized security testing, and research only. The author is not responsible for any misuse or damage caused by these tools. Always obtain explicit permission before testing on any system you do not own.

## Acknowledgments
*   The **Open5GS team** for their prompt response and for providing a patch in version `v2.7.6`.
*   To GMV for giving me time to carry out this research.
