
# CVE-2025-4094 – WordPress Digits Plugin < 8.4.6.1 - OTP Authentication Bypass

**Author:** [Saleh Tarawneh](https://github.com/starawneh)  
**CVE ID:** CVE-2025-4094  
**Severity:** Critical (CVSS 9.8)  
**Status:** Fixed in version 8.4.6.1

---

##  Vulnerability Description

The [Digits](https://digits.unitedover.com/) WordPress plugin prior to version 8.4.6.1 is vulnerable to OTP brute-force attacks due to missing rate limiting. This allows unauthenticated attackers to bypass SMS OTP-based authentication and reset passwords.

- CWE-287: Improper Authentication
- OWASP A2: Broken Authentication

---

##  Proof of Concept

### Option 1: Python Script (Automated)

Edit the placeholders inside `digits_otp_bypass_cve2025-4094.py`:

- `digits_phone`
- `instance_id`
- `digits_form`
- `Referer` / `redirect_page`
- Any other required values from the intercepted request

Then run:

```bash
python3 digits_otp_bypass_cve2025-4094.py
```
###  Option 2: Burp Suite Pro (Manual Brute Force)

You can also perform the attack using **Burp Suite Pro** and **Intruder**:

1. **Intercept** the OTP verification request using **Burp Proxy** during login or "Forgot Password" flow.
2. **Right-click** the request → **Send to Intruder**
3. Set the **payload position** on the `sms_otp` parameter.
4. Load a **payload list** from `000000` to `999999`:
5. **Start the attack** and monitor for a successful response by checking:
   - `"success":true` in the body
   - Change in **response length**


 
>  This method is useful for visual inspection and fine-tuning detection thresholds within Burp.

### Enhanced Script
- [Enhanced PoC](https://github.com/POCPioneer/CVE-2025-4094-POC) By POCPioneer

##  References

- [WPScan Vulnerability Entry](https://wpscan.com/vulnerability/b5f0a263-644b-4954-a1f0-d08e2149edbb)
- [WPVulnDB Entry](https://wpvulndb.com/vulnerabilities/b5f0a263-644b-4954-a1f0-d08e2149edbb)
- [Official Plugin Page](https://digits.unitedover.com/)
- [CVE ID – CVE-2025-4094](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-4094)

