# CVE-2025-39866 -  use-after-free 
**Author: Byte Reaper**


## Description
This POC attempts to exploit the CVE-2025-39866 vulnerability, which is a flaw in Linux systems < 6.12.16 due to the lack of a spinlock for threads, causing a race condition. The first thread tries to use the wb struct while thread 2 frees this structure, causing the first thread to deal with a free pointer, leading to a kernel panic for the system. We can divide the idea of exploiting the vulnerability into the following stages: 
```
step 1 : Create thread 1 "main pid" 
	 - get root dentry 
	- create file txt writeback target 
	- create strcut inode 
	 - Create object wb 
	 - save pointer wb in wb_old
Step 2: 
- Create Thread 2 (kthread) that schedules a work item.
- The work item runs “inode_switch_wbs_work_fn” which updates “inode->i_wb” and schedules the critical free via “wb_put_many”.
step 3 :
	- thread 2 : free wb_olb 
	- thread 1 -> pointer - free object wb (free old)
	-> access free address -> crash kernel (segfault)
```

## Requirements :
```
Linux x86_64
kernel linux  < 6.12.16
```

## Build :
```
	1 - He created a Makefile and included these commands to compile and build the kernel module:
	obj-m += exploit.o

	KDIR := /usr/src/linux-headers-6.12.38+kali-amd64
	PWD := $(shell pwd)

	all:
	        make -C $(KDIR) M=$(PWD) modules

	clean:
	        make -C $(KDIR) M=$(PWD) clean
```
## Run :
```
	# make clean 
	# make 
	1 -  You will find a file named "exploit.ko," which is a kernel module. To load it into the kernel space, use the insmod tool :
	# insmod exploit.ko 
```
## References : 
- NVD : https://nvd.nist.gov/vuln/detail/CVE-2025-39866
- CVE : https://www.cve.org/CVERecord?id=CVE-2025-39866
## Observation : 
- Soon, I will develop an exploit that uses other methods to manipulate the wb struct, such as reducing the refcount or deleting the wb cache from the list cache. I will also add attempts to execute Memory Spraying and attempts to detect leaks or escalate privileges in the system. This is just a proof of concept for the vulnerability.
## Solve the problem 
The main issue with the bug is the lack of a "spinlock" for thread synchronization. The solution here is:

First (Slab/Slub Allocation) , allocate a specific slab/slub for each thread, and no thread can control or manipulate the memory size of another thread.

Secondly (Synchronization) , configure the Workqueue to avoid interference and race conditions, where each thread finishes its task and moves to another thread instead of switching WB at the same time or using the wb_wakeup_delayed function.

Thirdly (HLE/RTM) : Activating HLE/RTM in the kernel depends on the processor architecture, but if it supports these two features, why not use them in the kernel, for example, in directing the flow of a program or when an error occurs, trying to revert to another exception instead of crashing "rollback" thru instructions like XBEGIN, XABORT, XEN.

## License : 

MIT


