# CVE-2025-39596
Quentn WP &lt;= 1.2.8 - Unauthenticated Privilege Escalation
# 🚨 Quentn WP <= 1.2.8 - Unauthenticated Privilege Escalation

## 📝 Description

The **Quentn WP** plugin for WordPress is vulnerable to Privilege Escalation in all versions up to, and including, **1.2.8**. This allows **unauthenticated attackers** to escalate their privileges to **administrator** level.

- **CVE:** `CVE-2025-39596`
- **CVSS:** `9.8 (Critical)`

---

## 💻 Exploit Script Description

This repository contains a Python exploit for CVE-2025-39596, allowing the creation of a new WordPress admin user **without authentication** using a crafted API request.

**Features:**
- HTTP/HTTPS auto-detection
- Advanced randomization & evasion headers
- Proxy, cookie, SSL-bypass, and header-bypass support
- Clean modular structure for easy tweaking

---

## ⚙️ Usage

```bash
python3 CVE-2025-39596.py -u <target_url> -e <email> [options]
```

**Required Arguments:**
- `-u`, `--url` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Target WordPress site URL (e.g., http://127.0.0.1/wordpress)
- `-e`, `--email` &nbsp;&nbsp;Email for the new admin account

**Optional Arguments:**
- `-f`, `--fname` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;First name (default: Pwn)
- `-l`, `--lname` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Last name (default: Admin)
- `-r`, `--role` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Role to assign (default: administrator)
- `-k`, `--key` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quentn API key if known
- `--cookie` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cookie for authenticated bypass if available
- `--proxy` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Proxy support (e.g., http://127.0.0.1:8080)
- `--skip-ssl` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip SSL verification
- `--extra` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Enable extra evasion headers

**Example:**
```bash
python3 CVE-2025-39596.py -u http://target.com/wordpress -e hacked@attacker.com --fname Root --lname User --proxy http://127.0.0.1:8080 --extra
```

---

## 📤 Output

- On **Success**:  
  `Exploit Success By | Nxploited`
- On **Failure**:  
  Shows the HTTP status code and response message for troubleshooting.

---

## ⚠️ Disclaimer

This tool is provided **for educational and authorized security testing purposes only**.  
**Any misuse is strictly prohibited.**  
The author is **not responsible** for any damage or misuse caused by this code.

---

**_By: Nxploited ( Khaled Alenazi )_**
