# CVE-2025-39401
WordPress WPAMS Plugin &lt;= 44.0 (17-08-2023) is vulnerable to a high priority Arbitrary File Upload

# ⚠️ CVE-2025-39401 - WPAMS <= 44.0 Arbitrary File Upload Exploit

> **WordPress WPAMS Plugin** `<= 44.0 (17-08-2023)` is vulnerable to a high priority Arbitrary File Upload.  
> **CVE:** [CVE-2025-39401](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-39401)  
> **Base Score:** **10.0 CRITICAL**

Unrestricted Upload of File with Dangerous Type vulnerability in mojoomla WPAMS lets attackers upload a web shell to the server, leading to full compromise.  
This affects WPAMS versions: `from n/a through 44.0 (17-08-2023)`.

---

## 🚀 Script Overview

**Script Name:** `CVE-2025-39401.py`

This script is a professional automated mass exploit tool that leverages the file upload vulnerability in WPAMS plugin.  
It performs the following:

- Mass exploitation against multiple WordPress targets using threading for speed.
- Uploads your custom shell (`shell.php`) directly via the vulnerable form.
- Bruteforces/fuzzes **timestamp-based filenames** to precisely locate the shell after upload.
- Verifies successful exploitation by checking shell content in HTTP response.
- Organizes results by logging all successful uploads.

---

## 🧰 Requirements

- **Python 3.7+**
- `requests` library
- `rich` library for colored, beautiful console output

Install dependencies:
```bash
pip install requests rich
```
**Make sure your shell file is named `shell.php` and is located in the same folder as the script.**

---

## 📝 Usage

1. **Prepare your targets list**
   - Fill a file (e.g. `list.txt`) with WordPress site URLs, one per line.

2. **Place your shell**
   - Put your shell at `shell.php` in the same directory.

3. **Run the exploit script**
   ```bash
   python CVE-2025-39401.py
   ```
   - Enter the filename containing targets (e.g. `list.txt`)
   - Enter the number of threads (default recommended is 10)
   - Enter your custom shell marker (string returned by your shell, e.g. `<b>Nxploited</b>`) or accept default

#### Results:
- Successful shell uploads are saved in:
  - `success_results.txt`
  - `uploaded_shells.txt`

---

## 📂 Shell Upload Path & Filename Calculation

**The shell is uploaded to:**  
```
/wp-content/uploads/apartment_assets/
```

**How is the shell filename calculated?**

The WPAMS plugin names the uploaded file with this pattern:
```
{UNIX_TIMESTAMP}-pimg-in.{ext}
```
Where:
- `UNIX_TIMESTAMP` = time of upload (seconds since epoch, as calculated by the server)
- `pimg` = fixed marker string
- `in` = fixed string
- `{ext}` = original file extension

**Example:**  
Your shell (`shell.php`) uploaded at `timestamp = 1764279528` will become:
```
1764279528-pimg-in.php
```
**The full URL will be:**  
```
http://target-site/wp-content/uploads/apartment_assets/1764279528-pimg-in.php
```
The script automatically calculates the range of timestamps around the local upload time, and checks each constructed path until it confirms your shell is accessible.

---

## ⚡ Main Features

- **Multithreaded mass exploitation**
- **Precise shell discovery** (timestamp window bruteforce)
- **Colored console reporting**
- **Results & shell path logging**
- **Full automation**

---

## 🛑 Disclaimer

This tool is released for **educational and authorized penetration testing purposes only.**  
Do **NOT** use it to compromise systems without explicit permission. Misuse is **illegal**.  
The author is **not responsible** for any activity nor damage resulting from use.

---

## 📬 Contact & Author Info

- **Telegram:** [@KNxploited](https://t.me/KNxploited)
- **GitHub:** [github.com/Nxploited](https://github.com/Nxploited)


---

### **By:** _**Nxploited (Khaled Alenazi)**_
