# **CVE-2025-3914 - Arbitrary File Upload in Aeropage Sync for Airtable (WordPress)**

## **Description**
The **Aeropage Sync for Airtable** WordPress plugin (≤ v3.2.0) is vulnerable to **authenticated arbitrary file uploads** due to insufficient file type validation in the `aeropage_media_downloader` function.  

- **Attack Vector**: Authenticated (Subscriber+ privileges)  
- **Impact**: Remote Code Execution (RCE) via malicious file upload  
- **CVSS Score**: **8.8 (High)**  
- **CVE ID**: **CVE-2025-3914**  

## **Vulnerable Code**
The plugin fails to properly validate:  
1. **File extensions**  
2. **MIME types** (`$mediaObject['type']` only checks superficial headers)  
3. **File content** (no magic byte verification)  

### **Key Vulnerable Functions**  
```php
// Insufficient MIME check (bypassable)
if(aeropageValidateMediaType($mediaObject['type'], $mimeTypes) == false){...}

// Direct file write (no sanitization)
$fp = fopen($uploadPathWithAttachmentID, 'w');
fwrite($fp, $downloadedfile);
```

## **Proof of Concept (PoC)**
### **Requirements**
- Python 3.x + `requests`  
- Valid **Subscriber-level** WordPress credentials  

### **Exploit Steps**
1. **Authenticate** as a low-privilege user (Subscriber)  
2. **Upload** a malicious `.php` file disguised as an image  
3. **Execute** arbitrary code via the uploaded file  

```bash
python3 CVE-2025-3914-PoC.py -u http://vulnerable-site.com -l subscriber -p password123
```

## **Mitigation**
1. **Update** to plugin version **> 3.2.0** (if available)  
2. **Implement**:  
   - File **signature validation** (`finfo_file()`)  
   - **Randomized filenames**  
   - **.htaccess** restrictions in upload directories  

## **References**
- [CVE-2025-3914](https://nvd.nist.gov/vuln/detail/CVE-2025-3914)  
- [OWASP Unrestricted File Upload](https://owasp.org/www-community/vulnerabilities/Unrestricted_File_Upload)  


---

### **Key Improvements Over Generic PoC**
1. **WordPress-specific authentication** (handles cookies/nonces)  
2. **Fake JPEG header** + PHP payload (bypasses superficial checks)  
3. **Automatic URL extraction** from response (if possible)  
4. **Subscriber-level focus** (matches CVE details)  

### **Usage**
```bash
python3 CVE-2025-3914-PoC.py -u http://wp-site.com -l subscriber -p password123
```

This provides a **realistic, weaponized exploit** for testing (use **only** on authorized systems!). Let me know if you'd like additional refinements. 🔥
