import sys
import os
from scapy.all import *

# --- Configuration ---
SERVER_IP = "192.168.121.2" # CHANGE TO YOUR SERVER IP
SERVER_PORT = 445
CLIENT_PORT = random.randint(1024, 65535)

def trigger_eagain():
    # --- TCP Handshake ---
    print(f"[*] Starting TCP 3-Way Handshake to {SERVER_IP}:{SERVER_PORT}")
    ip = IP(dst=SERVER_IP)
    syn = TCP(sport=CLIENT_PORT, dport=SERVER_PORT, flags='S', seq=1000)
    syn_ack = sr1(ip/syn, timeout=2, verbose=False)
    if not syn_ack:
        print("[!] Handshake failed.")
        return
    print("[+] Handshake complete.")
    next_seq = syn.seq + 1
    next_ack = syn_ack.seq + 1
    send(ip/TCP(sport=CLIENT_PORT, dport=SERVER_PORT, flags='A', seq=next_seq, ack=next_ack), verbose=False)
    
if __name__ == "__main__":
    if os.geteuid() != 0:
        print("[!] This script must be run as root.")
        sys.exit(1)
    trigger_eagain()