# CVE-2025-36911 scanner

Tests unauthenticated BR/EDR L2CAP connections to audio PSMs (A2DP/AVRCP) and detects Fast Pair service (GFPS) on BLE.

## Requirements (Linux)
- BlueZ installed and `bluetooth` service active for BLE functionality.
- Bluetooth adapter enabled (`bluetoothctl power on`).

### Debian based OS
```bash
sudo apt update
sudo apt install bluez bluez-tools
sudo systemctl enable --now bluetooth
rfkill unblock bluetooth
bluetoothctl power on
```

## Installation
```bash
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

## Usage
- Interactive BLE scan + BR/EDR test:
```bash
python CVE-2025-36911.py
```
- Direct BR/EDR address mode:
```bash
python CVE-2025-36911.py AA:BB:CC:DD:EE:FF
```
- BLE scan disabled (direct address only):
```bash
python CVE-2025-36911.py --skip-ble AA:BB:CC:DD:EE:FF
```
- Require device unpaired before testing:
```bash
python CVE-2025-36911.py --require-unpaired AA:BB:CC:DD:EE:FF
```
- Disable pairing during test:
```bash
python CVE-2025-36911.py --lock-pairing AA:BB:CC:DD:EE:FF
```
- Display help:
```bash
python CVE-2025-36911.py --help
```

## How It Works

**CVE-2025-36911** allows unauthenticated L2CAP connections to Bluetooth audio profiles without prior pairing. During testing, if an L2CAP connection to AVDTP (PSM 0x0019) or AVCTP (PSM 0x0017) succeeds without pairing, the device is vulnerable.

## Feedback

Feel free to contribute and raise any issues you find.

## Important Notes
- Don't accept any pairing requests during testing to avoid implicit bonding
- Test only on your own devices or with explicit authorization
- Device must be discoverable and in Bluetooth cache
- Use `--lock-pairing` to prevent automatic pairing during vulnerability testing
