# CVE-2025-36041 IBM MQ SSL Bypass Exploit

## Overview

This repository contains a proof-of-concept (PoC) exploit for **CVE-2025-36041**, a vulnerability in IBM MQ (Message Queue) that allows bypassing SSL certificate validation. By injecting a fake SSL certificate and using customized MQCONNX parameters, an unauthorized client connection to an IBM MQ server can be established.

## Features

* **SSL Bypass**: Injects a fake SSL KeyRepository to disable server certificate validation.
* **Automated Exploit**: Opens a specified queue and sends a test message (`"Hello MQ"`) to confirm successful exploitation.
* **Customizable**: Specify the target queue manager, queue name, and path to the fake SSL repository via command-line arguments.

## Prerequisites

* **IBM MQ Client SDK** (headers and libraries)
* **argparse.h** (for command-line parsing)
* **GCC** (or compatible C compiler)

Ensure IBM MQ client libraries are installed and environment variables (`MQ_INCLUDE_PATH`, `MQ_LIB_PATH`) are set accordingly.

## Building

gcc exploit.c argparse.c -o CVE-2025-36041 \
    -I/path/to/mqm/include \
    -L/path/to/mqm/lib -lmqm


## Usage

./CVE-2025-36041 \
    -p /path/to/fake/ssl \
    -n TARGET.QUEUE.NAME \
    -m QM1

**Parameters:**

* `-p, --path`    Path to the fake SSL KeyRepository directory.
* `-n, --name`    Target queue name to open and send message.
* `-m, --qmgr`    Queue Manager name.

## Example


./CVE-2025-36041 -p ./fake_ssl_repo -n MY.QUEUE -m QM1


If successful, you will see:


[+] Starting connection to IBM MQ...
[+] Connected successfully with fake SSL!
[+] Message sent successfully!

## Disclaimer

**For authorized penetration testing and educational purposes only.**
Unauthorized use of this PoC may violate local laws and regulations. The author assumes no liability for misuse.

---

*Author:* Byte Reaper
*CVE:* CVE-2025-36041

