# CVE-2025-3464-AsIO3-LPE
  CVE-2025-3464: Unprivileged LPE exploit for ASUS AsIO3.sys - TOCTOU auth bypass + PreviousMode decrement 
 # CVE-2025-3464: AsIO3.sys Local Privilege Escalation

This exploit will only work on Windows 11 22H2 or earlier. Microsoft fixed PreviousMode hijinks.

Local privilege escalation exploit for ASUS AsIO3.sys driver. Gets `NT AUTHORITY\SYSTEM` 

<img width="1795" height="933" alt="image" src="https://github.com/user-attachments/assets/d5c2509b-b06b-465d-b8dc-c45c44cbdf28" />


  ## Overview

  This exploit chains an authentication bypass (CVE-2025-3464) with a decrement primitive to escalate privileges from any local user to SYSTEM.

  | Property | Value |
  |----------|-------|
  | **CVE** | CVE-2025-3464 |
  | **Type** | Local Privilege Escalation |
  | **Driver** | AsIO3.sys (ASUS) |
  | **Tested** | Windows 11 22H2 (Build 22621) |

  ## Vulnerabilities

  ### CVE-2025-3464 - Authentication Bypass via TOCTOU

  The AsIO3.sys driver validates calling processes by checking if their executable path contains `AsusCertService` and verifying a SHA256 hash. This check is vulnerable to a Time-of-Check-Time-of-Use (TOCTOU) race condition using NTFS hardlinks.

  **Attack Flow:**
  1. Create hardlink at path containing `AsusCertService` pointing to exploit executable
  2. Spawn child process via hardlink (process image path now passes substring check)
  3. Swap hardlink to point to `AsusCertService.exe`
  4. Child opens device handle 
  5. Authorization granted to attacker-controlled process

  **Note:** The driver only checks if the path *contains* `AsusCertService` via substring match. Any user-writable path works (e.g., `C:\Users\Public\AsusCertService\`), making this exploitable without admin privileges.

  ### Decrement Primitive (IOCTL 0xA0402450)

  The driver exposes an IOCTL that calls `ObfDereferenceObject` on a user-controlled pointer. This performs an 8-byte atomic decrement at `(ObjectPtr - 0x30)`, providing an arbitrary decrement primitive.

  **Exploitation via PreviousMode:**
  - Leak KTHREAD address via `NtQuerySystemInformation(SystemHandleInformationEx)`
  - Target: `KTHREAD + 0x232` (PreviousMode field)
  - Decrement PreviousMode from 1 (UserMode) to 0 (KernelMode)
  - With PreviousMode=0, `NtReadVirtualMemory`/`NtWriteVirtualMemory` can access kernel memory
  - Walk EPROCESS list, steal SYSTEM token
  - Restore PreviousMode to 1 before spawning shell

  ## Usage

  ```bash
  # Compile (Linux cross-compile)
  x86_64-w64-mingw32-gcc -O2 -o AsIO3_FullExploit.exe AsIO3_FullExploit.c -lntdll -lshlwapi
  ```
  # On target (requires AsIO3.sys loaded)
  AsIO3_FullExploit.exe

  Prerequisites:
  - AsIO3.sys driver loaded (comes with ASUS Armoury Crate, AI Suite, etc.)
  - AsusCertService.exe accessible (searches common ASUS installation paths)
 

  Structure Offsets (Windows 11 22H2)

  KTHREAD + 0x232  = PreviousMode
  KTHREAD + 0x220  = Process (EPROCESS pointer)
  EPROCESS + 0x440 = UniqueProcessId
  EPROCESS + 0x448 = ActiveProcessLinks
  EPROCESS + 0x4B8 = Token

  Note: Offsets are version-specific. Verify for your target Windows build. Windows 23H2 throws a PREVIOUS_MODE_MISMATCH (0x1f9). A mitigation for these previous mode tricks.

  Technical Notes

  - The 8-byte decrement at KTHREAD+0x232 affects adjacent fields (UserAffinityPrimaryGroup, BasePriority)
  - Critical: PreviousMode MUST be restored to 1 before calling CreateProcess or any user-mode address space operations
  - Failure to restore PreviousMode causes BSOD in nt!PspLocateInPEManifest during process creation

  References

  - https://blog.talosintelligence.com/decrement-by-one-to-rule-them-all/
  - ASUS Armoury Crate / AI Suite driver components

  Disclaimer

  This code is provided for authorized security research and educational purposes only. Only use against systems you own or have explicit permission to test. Unauthorized access to computer systems is illegal.

