# CVE-2025-3419 - WordPress Eventin <= 4.0.26 - Arbitrary File Read

🔥 **Vulnerability Summary**

The Eventin plugin (<= 4.0.26) for WordPress contains an unauthenticated arbitrary file read vulnerability in the `proxy_image()` function. Attackers exploit insufficient input validation by manipulating the `url` parameter to fetch server files (e.g., `/etc/passwd`, `wp-config.php`). The function fails to restrict access to local file paths, allowing directory traversal (e.g., `../../`). This exposes sensitive data like database credentials, API keys, and system files. The flaw stems from missing sanitization checks before file operations.

🔍 **Affected Plugin**
- Plugin Name: Eventin
- Affected Version: <= 4.0.26
- Vulnerability Type: Unauthenticated Arbitrary File Read
- CVE ID: CVE-2025-3419
- CVSS Score: 9.8 (Critical)
- Impact: Sensitive File Disclosure

🧪 **Exploit Features**
- ✅ Automatically sends file read request to `?action=proxy_image&url=file:///etc/passwd`
- 🔎 Detects presence of `/etc/passwd` via keyword `root:x:0:0:`
- 🧠 Checks server header (`Apache` or `Nginx`)
- 💾 Saves:
  - All vulnerable targets to `result.txt`
  - Apache-based servers to `passwd_server_apache.txt`
  - Nginx-based servers to `passwd_server_nginx.txt`

🚀 **Usage**
1. Create a `list.txt` file containing target domains (one per line, without `http://` or `https://`)
   ```
   example.com
   site123.org
   ```

2. Run the script:
   ```bash
   python3 cve_2025_3419_checker.py
   ```

📁 **Output**
- `result.txt`: List of sites leaking `/etc/passwd`
- `passwd_server_apache.txt`: Apache servers vulnerable
- `passwd_server_nginx.txt`: Nginx servers vulnerable

🧠 **Researcher**
Credit: [DailyCVE](https://dailycve.com/wordpress-arbitrary-file-read-cve-2025-3419-critical/)

🔒 **Disclaimer:**  
This tool is for educational and authorized testing purposes only. Do not use against targets you do not have permission to assess.
