# Stored XSS in Coolify delete flow (CVE-2025-34157)
 
> **Affects:** Coolify ≤ **v4.0.0-beta.420.6**  
> **Fixed in:** **v4.0.0-beta.420.7**  
> **Severity:** **Critical (9.4)**  
> **CVSS 4.0 Vector:** `CVSS:4.0/AV:N/AC:L/AT:N/PR:L/UI:P/VC:H/VI:H/VA:H/SC:H/SI:H/SA:H`  
> **CWE:** CWE-79 (Cross-Site Scripting), CWE-20 (Improper Input Validation)




## Summary
A stored XSS in the project delete flow allows execution of attacker-controlled JavaScript in an administrator’s browser when the admin attempts to delete a project created by a low-privileged user. This can lead to takeover of the Coolify instance (cookies, API tokens, WebSocket/terminal actions).

- **Attack Vector:** Remote (any authenticated user, incl. member)
- **Privileges Required:** Low
- **User Interaction:** Admin interaction (delete action)
- **Impact:** Account/session takeover, project/resource/terminal access

## Affected versions
- All versions **prior to and including** `v4.0.0-beta.420.6`.

## Proof of Concept (PoC)
Steps and payloads are in [`/POC`](./POC).



