# ⚠️ CVE-2025-34152 – Shenzhen Aitemi M300 Wi-Fi Repeater RCE

## 🚨 Overview

Shenzhen Aitemi M300 Wi-Fi Repeater is affected by an **unauthenticated remote code execution (RCE)**.

* No login required
* Does **not** reboot the device
* Can be exploited remotely

---

## 🛠 Vulnerable Versions

| Version | Status                  |
| ------- | ----------------------- |
| 1.0.x   | ❌ Vulnerable            |
| 1.1.x   | ❌ Vulnerable            |
| 1.2.x   | ❌ Vulnerable            |
| 2.0.x   | ⚠️ Check Vendor Updates |

---

## 💡 Remediation

* Update to the latest firmware from vendor
* Restrict management interface access (LAN only)
* Enable firewall rules to block WAN access
* Monitor logs for suspicious requests

---


---

## 🧪 PoC (Lab Use Only)

> ⚠️ Do **not** use on public devices, only in a controlled lab environment.

```bash
go run CVE-2025-34152.go
```

---
## 🔗 References

* [CVE Details](https://www.cvedetails.com/cve/CVE-2025-34152)
* Vendor Advisory: Shenzhen Aitemi official site
* Exploit analysis: Security blogs

