#!/bin/bash
# Setup script for CVE-2025-33073
# Creates a virtual environment and installs required packages

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
VENV_DIR="$SCRIPT_DIR/venv"

echo "[*] Setting up virtual environment for CVE-2025-33073..."

# Create virtual environment if it doesn't exist
if [ ! -d "$VENV_DIR" ]; then
    echo "[*] Creating virtual environment..."
    python3 -m venv "$VENV_DIR"
else
    echo "[*] Virtual environment already exists."
fi

# Activate virtual environment
echo "[*] Activating virtual environment..."
source "$VENV_DIR/bin/activate"

# Upgrade pip
echo "[*] Upgrading pip..."
pip install --upgrade pip > /dev/null 2>&1

# Install requirements
echo "[*] Installing requirements..."
pip install -r "$SCRIPT_DIR/requirements.txt"

echo "[+] Setup complete!"
echo ""
echo "To use the virtual environment, run:"
echo "  source $VENV_DIR/bin/activate"
echo ""
echo "Or use the wrapper script:"
echo "  ./CVE-2025-33073.py [arguments]"
