#!/usr/bin/env python3
import os
import subprocess
import socket

def run(cmd):
    print(f"[+] Running: {cmd}")
    subprocess.run(cmd, shell=True, check=True)

def main():
    SHARE = "/var/www/webdav"
    LOCKDIR = "/usr/local/apache/var/DavLock"
    HOSTNAME = socket.gethostname()
    IPADDR = socket.gethostbyname(HOSTNAME)

    # Update & install apache
    run("sudo apt update")
    run("sudo apt install -y apache2 apache2-utils")

    # Create shared directory
    run(f"sudo mkdir -p {SHARE}")
    run(f"sudo chown -R www-data:www-data {SHARE}")
    run(f"sudo chmod -R 755 {SHARE}")

    # Enable DAV modules
    run("sudo a2enmod dav dav_fs")
    run("sudo systemctl reload apache2")

    # Create DAV lock directory
    run(f"sudo mkdir -p {LOCKDIR}")
    run(f"sudo chown www-data:www-data {LOCKDIR}")

    # Create webdav.conf
    webdav_conf = f"""<VirtualHost *:80>
    ServerAdmin admin@{HOSTNAME}
    DavLockDB {LOCKDIR}/DavLock
    Alias /webdav {SHARE}
    DocumentRoot /var/www/webdav

    <Directory />
        Options FollowSymLinks
        AllowOverride None
    </Directory>

    <Directory {SHARE}>
        DAV On
        Require all granted
        Options Indexes FollowSymLinks MultiViews
    </Directory>
</VirtualHost>"""
    with open("/tmp/webdav.conf", "w") as f:
        f.write(webdav_conf)
    run("sudo mv /tmp/webdav.conf /etc/apache2/sites-available/webdav.conf")

    # Modify default conf
    default_conf = f"""DavLockDB {LOCKDIR}/DavLock
<VirtualHost *:80>
    ServerAdmin webmaster@localhost
    Alias /webdav {SHARE}
    DocumentRoot /var/www/html

    <Directory {SHARE}>
        DAV On
        Require all granted
        Options Indexes FollowSymLinks
    </Directory>

    ErrorLog \${APACHE_LOG_DIR}/error.log
    CustomLog \${APACHE_LOG_DIR}/access.log combined
</VirtualHost>"""
    with open("/tmp/000-default.conf", "w") as f:
        f.write(default_conf)
    run("sudo mv /tmp/000-default.conf /etc/apache2/sites-available/000-default.conf")

    # Enable site and restart Apache
    run("sudo a2ensite webdav.conf")
    run("sudo systemctl reload apache2")
    run("sudo systemctl restart apache2")

    print("\n✅ WebDAV setup complete!")
    print(f"📂 Access via: http://{IPADDR}/webdav/")

if __name__ == "__main__":
    main()
