#!/usr/bin/env python
# coding:utf-8
import my_rdp
import sys
import json

def sodok(ip, port):
    """
    Fungsi utama untuk menjalankan pemeriksaan RDP pada satu target.
    """
    if not ip or not port:
        print("Error: IP dan Port harus disediakan.")
        return

    try:
        # Panggil fungsi inti dari library my_rdp
        # isscreen diatur ke False secara default, bisa diubah jika perlu
        ret = my_rdp.rdp_check(ip, int(port), timeout=5, isscreen=False)
        if ret:
            # Cetak hasil dalam format JSON yang rapi
            print(json.dumps(ret, indent=4))
        else:
            print(f"Tidak ada informasi RDP yang dapat diambil dari {ip}:{port} atau target tidak dapat dijangkau.")

    except Exception as e:
        print(f"Terjadi error saat memeriksa {ip}:{port}: {e}")

if __name__ == '__main__':
    # Memeriksa apakah argumen IP dan Port diberikan
    if len(sys.argv) != 3:
        print("Penggunaan: python3 sodok.py <TARGET_IP> <TARGET_PORT>")
        sys.exit(1)

    target_ip = sys.argv[1]
    target_port = sys.argv[2]
    
    sodok(target_ip, target_port)
