# CVE-2025-32462 – sudo提权验证脚本

这是一个验证**CVE‑2025‑32462**的脚本, 需要通过sudo权限进行检验, 主要用于安全排查(我写了一个安全工具, 预计未来完善后进行公开, 想要兼容可以参考`version.txt`格式).

---

## 文件结构

| 文件              | 说明                                                           |
| --------------- | ------------------------------------------------------------ |
| **Dockerfile**  | 我尝试构造了一个存在漏洞的docker环境文件, 但是这台破电脑已经没机会测试了, 可以自己尝试一下看看能不能运行起来. |
| **poc.sh**      | 这是CVE-2025-32462的漏洞验证文件, 匹配机制还不够完善, 不过基础测试也够用了.              |
| **version.txt** | 用于进行版本匹配工具的文件.                                               |

---

## 受影响版本

> sudo的受影响版本为1.8.8 - 1.9.17, 主要受影响为linux系统.

---

## 使用方式

```bash
# 1 – clone repository
$ git clone https://github.com/cryingn/CVE-2025-32462.git
$ cd CVE-2025-32462

# 2 – build and run test environment
$ sudo ./poc.sh
```

## 说明

使用`sudo`只是为了方便查找出无需权限的用户, 在正式提权中无需sudo权限.
