# CVE-2025-32462 – Sudo Privilege Escalation Verification Script

This is a verification script for **CVE‑2025‑32462** that requires sudo privileges for testing. It's primarily used for security investigations (I'm developing a security tool that will be publicly released after further improvements; for compatibility reference, check the `version.txt` format).

---

## File Structure

| File            | Description                                                                                                                                        |
| --------------- | -------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Dockerfile**  | I attempted to create a vulnerable Docker environment file, but couldn't fully test it on this old computer. Feel free to try running it yourself. |
| **poc.sh**      | This is the vulnerability verification file for CVE-2025-32462. The matching mechanism isn't perfect yet, but it's sufficient for basic testing.   |
| **version.txt** | File used for version matching in the tool.                                                                                                        |

---

## Affected Versions

> Affected sudo versions range from 1.8.8 to 1.9.17, primarily impacting Linux systems.

---

## Usage

```bash
# 1 – clone repository
$ git clone https://github.com/cryingn/CVE-2025-32462.git
$ cd CVE-2025-32462

# 2 – build and run test environment
$ sudo ./poc.sh
```

## Notes

The use of `sudo` is only for conveniently identifying users with passwordless privileges. Actual privilege escalation doesn't require sudo permissions.

